/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

/**
 * 描画モードを表す列挙型定数です。
 */
public enum BlendMode {

	//////////////////////////////////////////////////
	// “通常” カテゴリ
	//////////////////////////////////////////////////

	/**
	 * なし
	 */
	NONE,

	/**
	 * 通常
	 */
	NORMAL,

	/**
	 * ディザ合成
	 */
	DISSOLVE,

	/**
	 * ダイナミックディザ合成
	 */
	DANCING_DISSOLVE,


	//////////////////////////////////////////////////
	// “減算” カテゴリ
	//////////////////////////////////////////////////

	/**
	 * 比較(暗)
	 */
	DARKEN,

	/**
	 * 乗算
	 */
	MULTIPLY,

	/**
	 * 焼き込みカラー
	 */
	COLOR_BURN,

	/**
	 * 焼き込みリニア
	 */
	LINEAR_BURN,

	/**
	 * カラー比較(暗)
	 */
	DARKER_COLOR,


	//////////////////////////////////////////////////
	// “加算” カテゴリ
	//////////////////////////////////////////////////

	/**
	 * 加算
	 */
	ADD,

	/**
	 * 比較(明)
	 */
	LIGHTEN,

	/**
	 * スクリーン
	 */
	SCREEN,

	/**
	 * 覆い焼きカラー
	 */
	COLOR_DODGE,

	/**
	 * 覆い焼きリニア
	 */
	LINEAR_DODGE,

	/**
	 * カラー比較(明)
	 */
	LIGHTER_COLOR,


	//////////////////////////////////////////////////
	// “複雑” カテゴリ
	//////////////////////////////////////////////////

	/**
	 * オーバーレイ
	 */
	OVERLAY,

	/**
	 * ソフトライト
	 */
	SOFT_LIGHT,

	/**
	 * ハードライト
	 */
	HARD_LIGHT,

	/**
	 * リニアライト
	 */
	LINEAR_LIGHT,

	/**
	 * ビビッドライト
	 */
	VIVID_LIGHT,

	/**
	 * ピンライト
	 */
	PIN_LIGHT,

	/**
	 * ハードミックス
	 */
	HARD_MIX,


	//////////////////////////////////////////////////
	// “差” カテゴリ
	//////////////////////////////////////////////////

	/**
	 * 差
	 */
	DIFFERENCE,

	/**
	 * 除外
	 */
	EXCLUSION,


	//////////////////////////////////////////////////
	// “HSL” カテゴリ
	//////////////////////////////////////////////////

	/**
	 * 色相
	 */
	HUE,

	/**
	 * 彩度
	 */
	SATURATION,

	/**
	 * カラー
	 */
	COLOR,

	/**
	 * 輝度
	 */
	LUMINOSITY,


	//////////////////////////////////////////////////
	// “マット” カテゴリ
	//////////////////////////////////////////////////

	/**
	 * ステンシルアルファ
	 */
	STENCIL_ALPHA,

	/**
	 * ステンシルルミナンス
	 */
	STENCIL_LUMA,

	/**
	 * シルエットアルファ
	 */
	SILHOUETTE_ALPHA,

	/**
	 * シルエットルミナンス
	 */
	SILHOUETTE_LUMA;

}
