/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

import javax.media.opengl.GL2;

/**
 * ジオメトリシェーダの入力プリミティブの種類を表す列挙型です。
 * @since 0.5.1
 */
public enum GeometryInputType {

	POINTS					(GL2.GL_POINTS),

	LINES					(GL2.GL_LINES),

	LINES_ADJACENCY			(GL2.GL_LINES_ADJACENCY_ARB),

	TRIANGLES				(GL2.GL_TRIANGLES),

	TRIANGLES_ADJACENCY		(GL2.GL_TRIANGLES_ADJACENCY_ARB);


	public final int glInputType;

	GeometryInputType(int glInputType) {
		this.glInputType = glInputType;
	}

}
