/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.ProjectView;
import ch.kuramo.javie.app.wizards.SolidColorItemWizard;
import ch.kuramo.javie.core.Folder;

public class NewSolidColorItemAction extends Action {

	private final IWorkbenchWindow window;

	public NewSolidColorItemAction(IWorkbenchWindow window) {
		super("新規平面...");
		this.window = window;

		setId(CommandIds.NEW_SOLID_COLOR_ITEM);
		setActionDefinitionId(CommandIds.NEW_SOLID_COLOR_ITEM);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/new_solid_color_item.png"));
	}

	public void run() {
		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		if (pm != null) {
			Folder parent = null;
			ProjectView projectView = UIUtil.findView(window.getActivePage(), ProjectView.ID);
			if (projectView != null) {
				parent = projectView.getItemTreeInsertionPoint();
			}
			SolidColorItemWizard wizard = new SolidColorItemWizard(pm, parent);
			WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
			dialog.open();
		}
	}

}
