/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.SuperSampling;

public class LayerCompSuperSamplingOperation extends ProjectOperation {

	private final String _compId;

	private final SuperSampling _newValue;

	private final SuperSampling _oldValue;


	public LayerCompSuperSamplingOperation(ProjectManager pm, LayerComposition comp, SuperSampling newValue) {
		super(pm, "スーパーサンプリング設定の変更");

		pm.checkComposition(comp);

		_compId = comp.getId();
		_newValue = newValue;
		_oldValue = comp.getSuperSampling();
		_noEffect = (_newValue == _oldValue);
	}

	@Override
	protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		setSuperSampling(project, pm, _newValue);
		return Status.OK_STATUS;
	}

	@Override
	protected IStatus undo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		setSuperSampling(project, pm, _oldValue);
		return Status.OK_STATUS;
	}

	private void setSuperSampling(Project project, ProjectManager pm, SuperSampling superSampling) {
		LayerComposition comp = project.getComposition(_compId);
		comp.setSuperSampling(superSampling);

		if (pm != null) {
			pm.fireCompositionPropertyChange(comp, "superSampling");
		}
	}

}
