/*
 * Copyright (c) 2009-2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.AnimatableColor;

public class AnimatableColorElementDelegate extends AnimatableValueElementDelegate<Color> {

	private org.eclipse.swt.graphics.Color swtColor;


	public AnimatableColorElementDelegate(
			AnimatableValueElement element, String name, AnimatableColor avalue) {

		super(element, name, avalue);

		// treeの破棄と同時にswtColorも破棄する。
		// treeのライフサイクルはelementのそれよりも長いが、他に適切な場所がない。
		element.viewer.getTree().addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent e) {
				if (swtColor != null) {
					swtColor.dispose();
					swtColor = null;
				}
			}
		});
	}

	protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
		drawColor(gc, x, y, height);
	}

	protected boolean canDragGestureEdit() {
		return false;
	}

	protected Color dragGesture(double dx, double dy) {
		throw new UnsupportedOperationException("drag gesture edit is not supported");
	}

	protected boolean isInPlaceEditorActive() {
		// FIXME カラーダイアログが開いているときは true を返すべき？
		return false;
	}

	public void mouseDown(MouseEvent event, int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.VALUE_COL:
				if (event.button == 1) {
					Rectangle r = valueArea.get(0);
					if (r.contains(event.x, event.y)) {
						doColorDialog();
					}
				}
				break;

			default:
				super.mouseDown(event, columnIndex);
				break;
		}
	}

	private int drawColor(GC gc, int x, int y, int height) {
		Rectangle rect = new Rectangle(x+1, y+1, height-2, height-2);

		RGB rgb = getRGB();
		if (swtColor == null || !swtColor.getRGB().equals(rgb)) {
			if (swtColor != null) {
				swtColor.dispose();
			}
			swtColor = new org.eclipse.swt.graphics.Color(gc.getDevice(), rgb);
		}

		gc.setBackground(swtColor);
		gc.fillRectangle(rect);

		gc.setForeground(gc.getDevice().getSystemColor(SWT.COLOR_BLACK));
		gc.drawRectangle(rect.x, rect.y, rect.width-1, rect.height-1);

		valueArea.add(rect);

		return rect.x + rect.width;
	}

	private void doColorDialog() {
		ColorDialog dialog = new ColorDialog(element.viewer.getTree().getShell());
		dialog.setRGB(getRGB());
		RGB rgb = dialog.open();
		if (rgb != null) {
			modifyValue(new Color(rgb.red/255.0, rgb.green/255.0, rgb.blue/255.0, 1.0));
		}
	}

	private RGB getRGB() {
		return new RGB((int)Math.round(valueWithoutExpr.r*255),
					   (int)Math.round(valueWithoutExpr.g*255),
					   (int)Math.round(valueWithoutExpr.b*255));
	}

}
