/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;

public abstract class AnimatableValueElement extends Element {

	private AnimatableValueElementDelegate<?> delegate;


	public AnimatableValueElement(Element parent) {
		super(parent);
	}

	protected AnimatableValueElementDelegate<?> getDelegate() {
		if (delegate == null) {
			delegate = createDelegate();
		}
		return delegate;
	}

	public AnimatableValue<?> getAnimatableValue() {
		return getDelegate().avalue;
	}

	public Image getColumnImage(int columnIndex) {
		return getDelegate().getColumnImage(columnIndex);
	}

	public String getColumnText(int columnIndex) {
		return getDelegate().getColumnText(columnIndex);
	}

	public boolean hasChildren() {
		return getDelegate().hasChildren();
	}

	public Element[] getChildren() {
		return getDelegate().getChildren();
	}

	public void paintColumn(Event event) {
		super.paintColumn(event);
		getDelegate().paintColumn(event);
	}

	public void updateCursor(MouseEvent event, int columnIndex) {
		getDelegate().updateCursor(event, columnIndex);
	}

	public void mouseDown(MouseEvent event, int columnIndex) {
		getDelegate().mouseDown(event, columnIndex);
	}

	public boolean canEdit(int columnIndex) {
		return getDelegate().canEdit(columnIndex);
	}

	public CellEditor getCellEditor(int columnIndex) {
		return getDelegate().getCellEditor(columnIndex);
	}

	public Object getCellEditorValue(int columnIndex) {
		return getDelegate().getCellEditorValue(columnIndex);
	}

	public void setCellEditorValue(int columnIndex, Object value) {
		getDelegate().setCellEditorValue(columnIndex, value);
	}

	public boolean updateValue() {
		return getDelegate().updateValue();
	}

	public boolean hasExpression() {
		return getDelegate().hasExpression();
	}

	public ProjectOperation createAddExpressionOperation(ProjectManager pm) {
		if (hasExpression()) {
			throw new IllegalStateException("has expression");
		}
		return createModifyExpressionOperation(pm, getDefaultExpression());
	}

	protected abstract AnimatableValueElementDelegate<?> createDelegate();

	protected abstract ProjectOperation createModifyValueOperation(ProjectManager pm, Object newValue, String relation);

	protected abstract ProjectOperation createModifyExpressionOperation(ProjectManager pm, String newExpr);

	protected abstract ProjectOperation createModifyKeyframeOperation(ProjectManager pm, Time time, Object newValue, String relation);

	protected abstract ProjectOperation createClearKeyframesOperation(ProjectManager pm);

	protected abstract String getDefaultExpression();

}
