/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.List;
import java.util.Map;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Util;

public class EffectsElement extends Element {

	private final List<EffectElement> children = Util.newList();

	private final Map<Effect, EffectElement> childrenMap = Util.newMap();


	public EffectsElement(LayerElement parent) {
		super(parent);
	}

	public String getColumnText(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.NAME_COL:
				return "エフェクト";

			default:
				return null;
		}
	}

	@Override
	public boolean hasChildren() {
		return (getLayer().getEffects().size() > 0);
	}

	@Override
	public Element[] getChildren() {
		prepareChildren();
		return children.toArray(new Element[children.size()]);
	}

	private EffectableLayer getLayer() {
		return ((EffectableLayer) ((LayerElement) parent).layer);
	}

	private EffectElement getChildElement(Effect effect) {
		EffectElement child = childrenMap.get(effect);
		if (child == null) {
			child = new EffectElement(this, effect);
			childrenMap.put(effect, child);
		}
		return child;
	}

	private void prepareChildren() {
		children.clear();

		for (Effect effect : getLayer().getEffects()) {
			children.add(getChildElement(effect));
		}

		childrenMap.values().retainAll(children);
	}

}
