/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.wizards;

import org.eclipse.jface.wizard.Wizard;

import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.output.WindowsDirectShowOutput;

public class AVIOutputWizard extends Wizard {

	private final AVIOutputSettingsWizardPage page;

	private final WindowsDirectShowOutput output;


	public AVIOutputWizard(Composition composition, WindowsDirectShowOutput output) {
		super();
		this.page = new AVIOutputSettingsWizardPage(composition, output.getFile());
		this.output = output;

		setWindowTitle("書き出し - AVI");
	}

	public void addPages() {
		addPage(page);
	}

	public boolean performFinish() {
		page.saveDefaults();

		output.setFile(page.getFile());
		output.setBatch(page.isBatch());

		boolean videoEnabled = page.isVideoEnabled();
		output.setVideoEnabled(videoEnabled);

		if (videoEnabled) {
			output.setVideoChannels(page.getVideoChannels());
			output.setColorMatte(page.getColorMatte());
			output.setVideoCompressorSettings(page.getVideoCompressorSettings());
		}

		boolean audioEnabled = page.isAudioEnabled();
		output.setAudioEnabled(audioEnabled);

		if (audioEnabled) {
			output.setAudioMode(page.getAudioMode());
		}

		return true;
	}

}
