/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.wizards;

import org.eclipse.jface.wizard.Wizard;

import ch.kuramo.javie.app.project.ModifyMediaOptionsOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaOptions;

public class MediaOptionsWizard extends Wizard {

	private final ProjectManager projectManager;

	private final MediaItem mediaItem;

	private MediaOptionsWizardPage page;


	public MediaOptionsWizard(ProjectManager projectManager, MediaItem mediaItem) {
		super();
		this.projectManager = projectManager;
		this.mediaItem = mediaItem;

		setWindowTitle("メディアオプション：" + mediaItem.getName());
	}

	public void addPages() {
		page = new MediaOptionsWizardPage(mediaItem);
		addPage(page);
	}

	public boolean performFinish() {
		MediaOptions options = page.getMediaOptions();
		projectManager.postOperation(new ModifyMediaOptionsOperation(projectManager, mediaItem, options));
		return true;
	}

}
