/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.misc;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

import org.scannotation.ClasspathUrlFinder;

import ch.kuramo.javie.core.JavieRuntimeException;

public class ScannotationBugFix {

	public static void patch() {
		try {
			ClassLoader loader = ClasspathUrlFinder.class.getClassLoader();

			ClassPool pool = new ClassPool();
			pool.appendClassPath(new LoaderClassPath(loader));
			CtClass targetClass = pool.get("org.scannotation.archiveiterator.FileProtocolIteratorFactory");
			CtClass urlClass = pool.get("java.net.URL");
			CtClass filterClass = pool.get("org.scannotation.archiveiterator.Filter");

			CtMethod method = targetClass.getDeclaredMethod("create", new CtClass[] { urlClass, filterClass });
			method.instrument(new ExprEditor() {
				@Override
				public void edit(MethodCall m) throws CannotCompileException {
					if (m.getClassName().equals("java.net.URL") && m.getMethodName().equals("getPath")) {
						m.replace("$_ = $0.toURI().getPath();");
					}
				}
			});

			targetClass.toClass(loader, null);
	
		} catch (NotFoundException e) {
			throw new JavieRuntimeException(e);
		} catch (CannotCompileException e) {
			throw new JavieRuntimeException(e);
		}
	}


	private ScannotationBugFix() { }

}
