﻿/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#pragma once

#include "ForcibleARGB32.h"


class InputBase
{
	friend class Callback;

public:
	InputBase();
	virtual ~InputBase();

	virtual HRESULT InitWithFile(LPCWSTR file);

	LONGLONG GetDuration()	{ return mDuration; }

protected:
	virtual void GetMediaType(CMediaType* mediaType) = 0;
	virtual HRESULT ConnectSourceToGrabber(IBaseFilter* source, IBaseFilter* grabber) = 0;
	virtual HRESULT BufferCB(void* buffer, long bufferSize) = 0;

	HRESULT NextPin(IEnumPins* enumPins, PIN_DIRECTION pindir, IPin** pin);
	HRESULT FirstPin(IBaseFilter* filter, PIN_DIRECTION pindir, IPin** pin);
	HRESULT Connect(IBaseFilter* from, IBaseFilter* to);

	IGraphBuilder* mGraphBuilder;
	ISampleGrabber* mSampleGrabber;
	IMediaControl* mMediaControl;
	IMediaSeeking* mMediaSeeking;
	IMediaEvent* mMediaEvent;

	LONGLONG mDuration;

private:
	void AddToRot();
	void RemoveFromRot();
	DWORD mRotRegister;
};

class VideoInput : public InputBase
{
public:
	VideoInput();
	virtual ~VideoInput();

	virtual HRESULT InitWithFile(LPCWSTR file);
	HRESULT FrameImageAtTime(LONGLONG time, void* buffer);

	long GetWidth()				{ return mWidth; }
	long GetHeight()			{ return mHeight; }
	LONGLONG GetFrameDuration()	{ return mFrameDuration; }
	DWORD GetFourCC()			{ return mFourCC; }

protected:
	DWORD FourCC();
	virtual void GetMediaType(CMediaType* mediaType);
	virtual HRESULT ConnectSourceToGrabber(IBaseFilter* source, IBaseFilter* grabber);
	virtual HRESULT BufferCB(void* buffer, long bufferSize);

	ForcibleARGB32* mForcibleARGB32;

	long mWidth;
	long mHeight;
	LONGLONG mFrameDuration;
	DWORD mFourCC;

	void* mBuffer;
};

class AudioInput : public InputBase
{
public:
	AudioInput();
	virtual ~AudioInput();

	virtual HRESULT InitWithFile(LPCWSTR file);
	HRESULT FillBuffer(LONGLONG time, void* buffer, long bufferSize);

	long GetSampleRate()		{ return mSampleRate; }
	long GetSampleSizeInBits()	{ return mSampleSizeInBits; }
	long GetChannels()			{ return mChannels; }
	bool IsFloat()				{ return mFloat; }

protected:
	virtual void GetMediaType(CMediaType* mediaType);
	virtual HRESULT ConnectSourceToGrabber(IBaseFilter* source, IBaseFilter* grabber);
	virtual HRESULT BufferCB(void* buffer, long bufferSize);

	long mSampleRate;
	long mSampleSizeInBits;
	long mChannels;
	bool mFloat;

	char* mBuffer;
	long mRestSize;
	long mCallbackCount;
};

class Callback : public CUnknown, public ISampleGrabberCB
{
public:
	DECLARE_IUNKNOWN;

	Callback(InputBase* input);
	virtual ~Callback();

	STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void** ppv);
	STDMETHODIMP SampleCB(double sampleTime, IMediaSample* sample);
	STDMETHODIMP BufferCB(double sampleTime, BYTE* buffer, long bufferSize);

private:
	InputBase* mInput;
};
