/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.api.services.IVBOCache;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;
import javax.vecmath.Vector2d;

@Effect(id="ch.kuramo.javie.LensBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class LensBlur {
    @Property
    private IAnimatableLayerReference depthMapLayer;
    @Property(value="LUMINANCE")
    private IAnimatableEnum<DepthMapChannel> depthMapChannel;
    @Property
    private IAnimatableBoolean invertDepthMap;
    @Property(value="true")
    private IAnimatableBoolean stretchMapToFit;
    @Property(value="0", min="0", max="255")
    private IAnimatableDouble blurFocalDistance;
    @Property(value="HEXAGON")
    private IAnimatableEnum<IrisShape> irisShape;
    @Property
    private IAnimatableLayerReference irisLayer;
    @Property(value="LIMIT20")
    private IAnimatableEnum<RadiusLimit> radiusLimit;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble irisRadius;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble irisBladeCurvature;
    @Property(value="0")
    private IAnimatableDouble irisRotation;
    @Property(value="10", min="0")
    private IAnimatableDouble nonlinear;
    @Property(value="false")
    private IAnimatableBoolean repeatEdgePixels;
    private static final ConcurrentMap<String, float[]> coveragesCache = new ConcurrentHashMap<String, float[]>();
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IAntiAliasSupport aaSupport;
    private final IArrayPools arrayPools;
    private final IVBOCache vboCache;
    private final ITexture1DSupport tex1dSupport;
    private final IShaderRegistry shaders;
    private final IShaderProgram logarithmProgram;
    private final IShaderProgram coverageProgram;
    private static final String[] FS_SOURCE = new String[]{"#version 120", "", "uniform sampler2D iris;", "", "varying vec4 frontColorA;", "varying vec4 frontColorB;", "varying vec2 pointCoordAdjAB;", "", "void main(void)", "{", "\tvec2 pointCoord2 = gl_PointCoord - 0.5;", "\tvec2 irisCoordA = pointCoord2 * pointCoordAdjAB.x + 0.5;", "\tvec2 irisCoordB = pointCoord2 * pointCoordAdjAB.y + 0.5;", "\tvec4 irisColorA = texture2D(iris, irisCoordA);", "\tvec4 irisColorB = texture2D(iris, irisCoordB);", "\tirisColorA.a = dot(irisColorA.rgb, vec3(0.299, 0.587, 0.114));", "\tirisColorB.a = dot(irisColorB.rgb, vec3(0.299, 0.587, 0.114));", "\tgl_FragColor = frontColorA * irisColorA + frontColorB * irisColorB;", "}"};
    @ShaderSource
    public static final String[] LOGARITHM = new String[]{"uniform sampler2D texture;", "uniform float n_minus_o;", "uniform float o_div_ln;", "", "void main(void)", "{", "\tvec4 color = texture2D(texture, gl_TexCoord[0].st);", "\tcolor.rgb = log(color.rgb * n_minus_o + 1.0) * o_div_ln;", "\tgl_FragColor = color;", "}"};
    @ShaderSource
    public static final String[] COVERAGE = new String[]{"#version 120", "", "uniform sampler2D iris;", "uniform float pointCoordAdj;", "", "void main(void)", "{", "\tvec2 irisCoord = (gl_PointCoord - 0.5) * pointCoordAdj + 0.5;", "\tgl_FragColor = texture2D(iris, irisCoord);", "}"};

    @Inject
    public LensBlur(IVideoEffectContext context, IVideoRenderSupport support, IAntiAliasSupport aaSupport, IArrayPools arrayPools, IVBOCache vboCache, ITexture1DSupport tex1dSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.aaSupport = aaSupport;
        this.arrayPools = arrayPools;
        this.vboCache = vboCache;
        this.tex1dSupport = tex1dSupport;
        this.shaders = shaders;
        this.logarithmProgram = shaders.getProgram(LensBlur.class, "LOGARITHM");
        this.coverageProgram = shaders.getProgram(LensBlur.class, "COVERAGE");
    }

    public VideoBounds getVideoBounds() {
        VideoBounds srcBounds = this.context.getPreviousBounds();
        if (srcBounds.isEmpty()) {
            return srcBounds;
        }
        if (((Boolean)this.context.value((IAnimatableValue)this.repeatEdgePixels)).booleanValue()) {
            return srcBounds;
        }
        double irisRadius = (Double)this.context.value((IAnimatableValue)this.irisRadius);
        RadiusLimit radiusLimit = (RadiusLimit)((Object)this.context.value(this.radiusLimit));
        if (radiusLimit != RadiusLimit.NONE) {
            irisRadius = Math.min(irisRadius, (double)(radiusLimit.ordinal() * 20));
        }
        irisRadius = this.context.getVideoResolution().scale(irisRadius);
        int ceiledRadius = (int)Math.ceil(irisRadius);
        return new VideoBounds(srcBounds.x - (double)ceiledRadius, srcBounds.y - (double)ceiledRadius, srcBounds.width + ceiledRadius * 2, srcBounds.height + ceiledRadius * 2);
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer iVideoBuffer;
        IVideoBuffer buffer2;
        IVideoBuffer buffer1;
        IVideoBuffer depthBuffer;
        IVideoBuffer irisBuffer;
        IVideoBuffer source;
        block30: {
            source = this.context.doPreviousEffect();
            VideoBounds srcBounds = source.getBounds();
            if (srcBounds.isEmpty()) {
                return source;
            }
            irisBuffer = null;
            depthBuffer = null;
            buffer1 = null;
            buffer2 = null;
            int coveragesTex = 0;
            try {
                boolean stretchDepth;
                VideoBounds resultBounds;
                int[] vboIdAndNumPoints;
                boolean repeatEdgePixels = (Boolean)this.context.value((IAnimatableValue)this.repeatEdgePixels);
                double irisRadius = (Double)this.context.value((IAnimatableValue)this.irisRadius);
                RadiusLimit radiusLimit = (RadiusLimit)((Object)this.context.value(this.radiusLimit));
                if (radiusLimit != RadiusLimit.NONE) {
                    irisRadius = Math.min(irisRadius, (double)(radiusLimit.ordinal() * 20));
                }
                irisRadius = this.context.getVideoResolution().scale(irisRadius);
                int ceiledRadius = (int)Math.ceil(irisRadius);
                if (repeatEdgePixels) {
                    vboIdAndNumPoints = this.createPointsBuffer(srcBounds, ceiledRadius);
                    resultBounds = srcBounds;
                } else {
                    vboIdAndNumPoints = this.createPointsBuffer(srcBounds, 0);
                    resultBounds = new VideoBounds(srcBounds.x - (double)ceiledRadius, srcBounds.y - (double)ceiledRadius, srcBounds.width + ceiledRadius * 2, srcBounds.height + ceiledRadius * 2);
                }
                IrisShape irisShape = (IrisShape)((Object)this.context.value(this.irisShape));
                double irisRotation = (Double)this.context.value((IAnimatableValue)this.irisRotation);
                float[] irisCoverages = new float[101];
                if (irisShape != IrisShape.IRIS_LAYER) {
                    double irisBladeCurvature = (Double)this.context.value((IAnimatableValue)this.irisBladeCurvature) / 100.0;
                    irisBuffer = this.createPolygonIris(irisRadius, irisShape.ordinal() + 3, irisBladeCurvature, irisRotation, irisCoverages);
                } else {
                    IVideoBuffer irisLayer = null;
                    try {
                        irisLayer = this.context.getLayerVideoFrame(this.irisLayer);
                        if (irisLayer != null) {
                            irisLayer.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
                            irisBuffer = this.createLayerIris(irisLayer, irisRadius, irisRotation, irisCoverages);
                        } else {
                            irisBuffer = this.createPolygonIris(irisRadius, 4, 0.0, irisRotation - 45.0, irisCoverages);
                        }
                    }
                    finally {
                        if (irisLayer != null) {
                            irisLayer.dispose();
                        }
                    }
                }
                depthBuffer = this.context.getLayerVideoFrame(this.depthMapLayer);
                if (depthBuffer == null) {
                    depthBuffer = this.context.createVideoBuffer(new VideoBounds(1, 1));
                    depthBuffer.clear(Color.WHITE);
                    stretchDepth = true;
                } else {
                    stretchDepth = (Boolean)this.context.value((IAnimatableValue)this.stretchMapToFit);
                }
                final IShaderProgram program = this.getProgram((DepthMapChannel)((Object)this.context.value(this.depthMapChannel)), (Boolean)this.context.value((IAnimatableValue)this.invertDepthMap), stretchDepth);
                final int coveragesTex_ = coveragesTex = this.tex1dSupport.texture1DFromArray(irisCoverages, 6406, 34844, 9728, 33071);
                int maxPointSize = ceiledRadius * 2 + 3;
                final int maxNumPointsPerOnePass = (int)Math.ceil((double)vboIdAndNumPoints[1] * 400.0 / (double)(maxPointSize * maxPointSize));
                Runnable operation = new Runnable(){

                    public void run() {
                        LensBlur.this.support.ortho2D(resultBounds);
                        GL2 gl = LensBlur.this.context.getGL().getGL2();
                        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                        gl.glClear(16384);
                        gl.glEnable(3042);
                        gl.glBlendFunc(1, 1);
                        gl.glBlendEquation(32774);
                        gl.glEnable(34370);
                        gl.glEnable(34913);
                        int[] pointSpriteCoordOrigin = new int[1];
                        gl.glGetIntegerv(36000, pointSpriteCoordOrigin, 0);
                        gl.glActiveTexture(33987);
                        gl.glBindTexture(3552, coveragesTex_);
                        int attr1Loc = program.getAttributeLocation("attr1");
                        try {
                            gl.glPointParameteri(36000, 36001);
                            gl.glEnableVertexAttribArray(attr1Loc);
                            gl.glBindBuffer(34962, vboIdAndNumPoints[0]);
                            gl.glVertexAttribPointer(attr1Loc, 2, 5126, false, 8, 0L);
                            int i = 0;
                            int offset = 0;
                            while (offset < vboIdAndNumPoints[1]) {
                                int count = Math.min(vboIdAndNumPoints[1] - offset, maxNumPointsPerOnePass);
                                gl.glDrawArrays(0, offset, count);
                                gl.glFinish();
                                offset += count;
                                ++i;
                            }
                        }
                        finally {
                            gl.glBindBuffer(34962, 0);
                            gl.glDisableVertexAttribArray(attr1Loc);
                            gl.glPointParameteri(36000, pointSpriteCoordOrigin[0]);
                        }
                    }
                };
                double focalDistance = (Double)this.context.value((IAnimatableValue)this.blurFocalDistance) / 255.0;
                double nonlinear = (Double)this.context.value((IAnimatableValue)this.nonlinear) * 10.0 + 1.0001;
                HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
                uniforms.add(new GLUniformData("texture", 0));
                uniforms.add(new GLUniformData("iris", 1));
                uniforms.add(new GLUniformData("depth", 2));
                uniforms.add(new GLUniformData("coverages", 3));
                uniforms.add(new GLUniformData("texOffset", 2, this.toFloatBuffer(-srcBounds.x, -srcBounds.y)));
                uniforms.add(new GLUniformData("o_div_txsz", 2, this.toFloatBuffer(1.0 / (double)srcBounds.width, 1.0 / (double)srcBounds.height)));
                uniforms.add(new GLUniformData("focalDistance", (float)focalDistance));
                uniforms.add(new GLUniformData("irisRadius", (float)irisRadius));
                uniforms.add(new GLUniformData("nonlinear", (float)nonlinear));
                uniforms.add(new GLUniformData("o_div_nmo", (float)(1.0 / (nonlinear - 1.0))));
                buffer1 = this.support.createVideoBuffer(resultBounds, ColorMode.RGBA32_FLOAT);
                source.setTextureWrapMode(repeatEdgePixels ? IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE : IVideoBuffer.TextureWrapMode.CLAMP_TO_BORDER);
                VideoBounds depthBounds = depthBuffer.getBounds();
                boolean mipmap = false;
                if (stretchDepth) {
                    mipmap = depthBounds.width < srcBounds.width || depthBounds.height < srcBounds.height;
                } else {
                    uniforms.add(new GLUniformData("depTexOffset", 2, this.toFloatBuffer((double)(depthBounds.width - srcBounds.width) * 0.5, (double)(depthBounds.height - srcBounds.height) * 0.5)));
                    uniforms.add(new GLUniformData("o_div_depsz", 2, this.toFloatBuffer(1.0 / (double)depthBounds.width, 1.0 / (double)depthBounds.height)));
                }
                depthBuffer.setTextureFilter(mipmap ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR);
                depthBuffer.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                int pushAttribs = 286720;
                this.support.useShaderProgram(program, uniforms, operation, pushAttribs, buffer1, new IVideoBuffer[]{source, irisBuffer, depthBuffer});
                uniforms.clear();
                uniforms.add(new GLUniformData("texture", 0));
                uniforms.add(new GLUniformData("n_minus_o", (float)(nonlinear - 1.0)));
                uniforms.add(new GLUniformData("o_div_ln", (float)(1.0 / Math.log(nonlinear))));
                buffer2 = this.support.createVideoBuffer(resultBounds);
                this.support.useShaderProgram(this.logarithmProgram, uniforms, buffer2, new IVideoBuffer[]{buffer1});
                IVideoBuffer result = buffer2;
                buffer2 = null;
                iVideoBuffer = result;
                if (coveragesTex == 0) break block30;
            }
            catch (Throwable throwable) {
                if (coveragesTex != 0) {
                    this.context.getGL().glDeleteTextures(1, new int[]{coveragesTex}, 0);
                }
                if (buffer2 != null) {
                    buffer2.dispose();
                }
                if (buffer1 != null) {
                    buffer1.dispose();
                }
                if (depthBuffer != null) {
                    depthBuffer.dispose();
                }
                if (irisBuffer != null) {
                    irisBuffer.dispose();
                }
                if (source != null) {
                    source.dispose();
                }
                throw throwable;
            }
            this.context.getGL().glDeleteTextures(1, new int[]{coveragesTex}, 0);
        }
        if (buffer2 != null) {
            buffer2.dispose();
        }
        if (buffer1 != null) {
            buffer1.dispose();
        }
        if (depthBuffer != null) {
            depthBuffer.dispose();
        }
        if (irisBuffer != null) {
            irisBuffer.dispose();
        }
        if (source != null) {
            source.dispose();
        }
        return iVideoBuffer;
    }

    private int[] createPointsBuffer(VideoBounds srcBounds, int ceiledRadius) {
        int numVerticesX = srcBounds.width + ceiledRadius * 2;
        int numVerticesY = srcBounds.height + ceiledRadius * 2;
        int numVertices = numVerticesX * numVerticesY;
        String token = String.format("%d,%d,%d,%d/%d", Double.doubleToLongBits(srcBounds.x), Double.doubleToLongBits(srcBounds.y), srcBounds.width, srcBounds.height, ceiledRadius);
        IVBOCache.VBOCacheRecord rec = this.vboCache.get((Object)this);
        if (rec != null && token.equals(rec.data)) {
            return new int[]{rec.vboId, numVertices};
        }
        GL2 gl = this.context.getGL().getGL2();
        int[] vboId = new int[1];
        IArray data = null;
        try {
            data = this.arrayPools.getFloatArray(numVertices * 2);
            float[] array = (float[])data.getArray();
            int j = 0;
            int k = 0;
            while (j < numVerticesY) {
                int i = 0;
                while (i < numVerticesX) {
                    array[k++] = (float)(srcBounds.x - (double)ceiledRadius + (double)i + 0.5);
                    array[k++] = (float)(srcBounds.y - (double)ceiledRadius + (double)j + 0.5);
                    ++i;
                }
                ++j;
            }
            gl.glGenBuffers(1, vboId, 0);
            gl.glBindBuffer(34962, vboId[0]);
            gl.glBufferData(34962, (long)(data.getLength() * 4), (Buffer)FloatBuffer.wrap((float[])data.getArray()), 35044);
            this.vboCache.put((Object)this, new IVBOCache.VBOCacheRecord(vboId[0], (Object)token));
            int[] result = new int[]{vboId[0], numVertices};
            vboId = null;
            int[] nArray = result;
            return nArray;
        }
        finally {
            gl.glBindBuffer(34962, 0);
            if (vboId != null && vboId[0] != 0) {
                gl.glDeleteBuffers(1, vboId, 0);
            }
            if (data != null) {
                data.release();
            }
        }
    }

    private IVideoBuffer createPolygonIris(double radius, final int n, final double bladeCurvature, final double rotation, float[] coverages) {
        int pot = 1;
        while ((double)pot < radius * 2.0 + 1.0 && pot < 128) {
            pot <<= 1;
        }
        int texSize = Math.max(8, pot);
        final double texRadius = (double)texSize * 0.5;
        final VideoBounds bounds = new VideoBounds(texSize, texSize);
        IVideoBuffer buffer = null;
        try {
            Runnable operation = new Runnable(){

                public void run() {
                    LensBlur.this.aaSupport.antiAlias(bounds.width, bounds.height, new Runnable(){

                        public void run() {
                            LensBlur.this.support.ortho2D(bounds);
                            GL2 gl = LensBlur.this.context.getGL().getGL2();
                            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                            gl.glBegin(9);
                            int n2 = (int)Math.ceil(360.0 / (double)n / 5.0);
                            double dr = 360.0 / (double)n / (double)n2;
                            int i = 0;
                            while (i < n) {
                                double r0 = Math.toRadians(rotation + 360.0 / (double)n * (double)i);
                                double x0 = texRadius + texRadius * Math.sin(r0);
                                double y0 = texRadius - texRadius * Math.cos(r0);
                                gl.glVertex2f((float)x0, (float)y0);
                                if (bladeCurvature > 0.0) {
                                    double r1 = r0 + Math.toRadians(360.0 / (double)n);
                                    double x1 = texRadius + texRadius * Math.sin(r1);
                                    double y1 = texRadius - texRadius * Math.cos(r1);
                                    Vector2d v1 = new Vector2d(x1 - x0, y1 - y0);
                                    v1.normalize();
                                    int j = 1;
                                    while (j < n2) {
                                        double r2 = r0 + Math.toRadians(dr * (double)j);
                                        double x2 = texRadius + texRadius * Math.sin(r2);
                                        double y2 = texRadius - texRadius * Math.cos(r2);
                                        Vector2d v2 = new Vector2d(x2 - x0, y2 - y0);
                                        Vector2d v3 = new Vector2d(v1);
                                        v3.scale(v2.dot(v1));
                                        gl.glVertex2f((float)((x0 + v3.x) * (1.0 - bladeCurvature) + x2 * bladeCurvature), (float)((y0 + v3.y) * (1.0 - bladeCurvature) + y2 * bladeCurvature));
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                            gl.glEnd();
                        }
                    });
                }
            };
            buffer = this.context.createVideoBuffer(bounds);
            int pushAttribs = 1;
            this.support.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[0]);
            buffer.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
            String key = String.format("%d,%d,%d,%d", texSize, n, Double.doubleToLongBits(bladeCurvature), Double.doubleToLongBits(rotation));
            float[] coveragesFromCache = (float[])coveragesCache.get(key);
            if (coveragesFromCache != null) {
                System.arraycopy(coveragesFromCache, 0, coverages, 0, coverages.length);
            } else {
                this.measureCoverages(buffer, coverages);
                coveragesCache.putIfAbsent(key, (float[])coverages.clone());
            }
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer createLayerIris(IVideoBuffer irisLayer, double radius, final double rotation, float[] coverages) {
        int pot = 1;
        while ((double)pot < radius * 2.0 + 1.0 && pot < 128) {
            pot <<= 1;
        }
        int texSize = Math.max(8, pot);
        final double texRadius = (double)texSize * 0.5;
        final VideoBounds bounds = new VideoBounds(texSize, texSize);
        IVideoBuffer buffer = null;
        Object copy = null;
        try {
            Runnable operation = new Runnable(){

                public void run() {
                    LensBlur.this.aaSupport.antiAlias(bounds.width, bounds.height, new Runnable(){

                        public void run() {
                            LensBlur.this.support.ortho2D(bounds);
                            GL2 gl = LensBlur.this.context.getGL().getGL2();
                            gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                            gl.glClear(16384);
                            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                            gl.glTranslatef((float)texRadius, (float)texRadius, 0.0f);
                            gl.glRotatef((float)rotation, 0.0f, 0.0f, 1.0f);
                            gl.glTranslatef((float)(-texRadius), (float)(-texRadius), 0.0f);
                            double lt = texRadius - texRadius / Math.sqrt(2.0);
                            double rb = texRadius + texRadius / Math.sqrt(2.0);
                            LensBlur.this.support.quad2D(lt, lt, rb, rb, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
                        }
                    });
                }
            };
            buffer = this.context.createVideoBuffer(bounds);
            int pushAttribs = 16385;
            this.support.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[]{irisLayer});
            buffer.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
            this.measureCoverages(buffer, coverages);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (copy != null) {
                copy.dispose();
            }
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private IShaderProgram getProgram(DepthMapChannel depthChannel, boolean invertDepth, boolean stretchDepth) {
        String programName = String.valueOf(LensBlur.class.getName()) + "." + depthChannel.name() + (invertDepth ? ".INVERT_DEPTH" : "") + (stretchDepth ? ".STRETCH_DEPTH" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            String[] vertexSource = LensBlur.createVertexShaderSource(depthChannel, invertDepth, stretchDepth);
            String vertexName = String.valueOf(programName) + "_VS";
            this.shaders.registerShader(vertexName, ShaderType.VERTEX_SHADER, vertexSource);
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, new String[]{vertexName}, FS_SOURCE);
        }
        return program;
    }

    private static String[] createVertexShaderSource(DepthMapChannel depthChannel, boolean invertDepth, boolean stretchDepth) {
        boolean inv = invertDepth;
        boolean str = stretchDepth;
        return new String[]{"#define CHANNEL " + depthChannel.ordinal(), inv ? "#define INVERT_DEPTH" : "", str ? "#define STRETCH_DEPTH" : "", "", "attribute vec2 attr1;", "", "uniform sampler2D texture;", "uniform sampler2D depth;", "uniform sampler1D coverages;", "uniform vec2 texOffset;", "uniform vec2 o_div_txsz;", "uniform float focalDistance;", "uniform float irisRadius;", "uniform float nonlinear;", "uniform float o_div_nmo;", "", "#ifndef STRETCH_DEPTH", "\tuniform vec2 depTexOffset;", "\tuniform vec2 o_div_depsz;", "#endif", "", "varying vec4 frontColorA;", "varying vec4 frontColorB;", "varying vec2 pointCoordAdjAB;", "", "void main(void)", "{", "", "\tgl_Position = gl_ProjectionMatrix * vec4(attr1, 0.0, 1.0);", "", "\tvec2 texPoint = attr1.xy + texOffset;", "\tvec2 texCoord = texPoint * o_div_txsz;", "\tvec4 color = texture2D(texture, texCoord);", "", "#ifdef STRETCH_DEPTH", "\tvec4 depColor = texture2D(depth, texCoord);", "#else", "\tvec4 depColor = texture2D(depth, (texPoint + depTexOffset) * o_div_depsz);", "#endif", "#if CHANNEL == 0", "\tfloat depValue = dot(depColor.rgb, vec3(0.299, 0.587, 0.114));", "#elif CHANNEL == 1", "\tfloat depValue = depColor.r;", "#elif CHANNEL == 2", "\tfloat depValue = depColor.g;", "#elif CHANNEL == 3", "\tfloat depValue = depColor.b;", "#elif CHANNEL == 4", "\tfloat depValue = depColor.a;", "#endif", "#ifdef INVERT_DEPTH", "\tdepValue = 1.0 - depValue;", "#endif", "\tfloat blur = depValue - focalDistance;", "\tfloat absBlur = abs(blur);", "", "\tfloat radius = irisRadius * absBlur;", "\tfloat radiusA = floor(radius);", "\tfloat radiusB = radiusA + 1.0;", "\tvec2 radiusAB = vec2(radiusA, radiusB);", "\tvec2 radiusAB05 = radiusAB + 0.5;", "\tvec2 squareAB = radiusAB05 * radiusAB05 * 4.0;", "\tvec2 cvrCoordAB = radiusAB05 / 101.0;", "\tvec2 areaAB = squareAB * vec2(texture1D(coverages, cvrCoordAB.x).a,", "\t\t\t\t\t\t\t\t  texture1D(coverages, cvrCoordAB.y).a);", "\tfloat t = radius - radiusA;", "\tcolor.rgb = (pow(vec3(nonlinear), color.rgb)-1.0) * o_div_nmo;", "\tfrontColorA = color / areaAB.x * (1.0-t);", "\tfrontColorB = color / areaAB.y * t;", "\tgl_PointSize = radiusB * 2.0 + 3.0;", "\tpointCoordAdjAB = gl_PointSize / (radiusAB * 2.0 + 1.0) * (blur < 0.0 ? -1.0 : 1.0);", "}"};
    }

    private void measureCoverages(IVideoBuffer irisBuffer, float[] coverages) {
        VideoBounds bounds0 = irisBuffer.getBounds();
        int maxLv = 0;
        int pot = 1;
        while (pot < bounds0.width) {
            pot <<= 1;
            ++maxLv;
        }
        int i = 0;
        int lv = maxLv;
        while (i < coverages.length) {
            int irisSize = i * 2 + 1;
            if (i <= 20 || i % 10 == 0) {
                int pointSize = i * 2 + 3;
                coverages[i] = (float)this.measureCoverage(irisBuffer, irisSize, pointSize);
            } else {
                coverages[i] = coverages[i - 1];
            }
            while (irisSize > bounds0.width / (1 << lv)) {
                if (--lv >= 0) continue;
                Arrays.fill(coverages, i + 1, coverages.length, coverages[i]);
                return;
            }
            ++i;
        }
    }

    private double measureCoverage(IVideoBuffer irisBuffer, double irisSize, final int pointSize) {
        IVideoBuffer tmp = null;
        try {
            final VideoBounds bounds = new VideoBounds(pointSize, pointSize);
            tmp = this.support.createVideoBuffer(bounds, ColorMode.RGBA16_FLOAT);
            Runnable operation = new Runnable(){

                public void run() {
                    LensBlur.this.support.ortho2D(bounds);
                    GL2 gl = LensBlur.this.context.getGL().getGL2();
                    gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                    gl.glClear(16384);
                    gl.glEnable(34913);
                    gl.glPointSize((float)pointSize);
                    int[] pointSpriteCoordOrigin = new int[1];
                    gl.glGetIntegerv(36000, pointSpriteCoordOrigin, 0);
                    try {
                        gl.glPointParameteri(36000, 36001);
                        gl.glBegin(0);
                        gl.glVertex2f((float)(bounds.x + (double)bounds.width * 0.5), (float)(bounds.y + (double)bounds.height * 0.5));
                        gl.glEnd();
                    }
                    finally {
                        gl.glPointParameteri(36000, pointSpriteCoordOrigin[0]);
                    }
                }
            };
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("iris", 0));
            uniforms.add(new GLUniformData("pointCoordAdj", (float)((double)pointSize / irisSize)));
            int pushAttribs = 24578;
            this.support.useShaderProgram(this.coverageProgram, uniforms, operation, pushAttribs, tmp, new IVideoBuffer[]{irisBuffer});
            float[] array = (float[])tmp.getArray();
            double r = 0.0;
            double g = 0.0;
            double b = 0.0;
            int i = 0;
            int j = 0;
            int n = bounds.width * bounds.height;
            while (i < n) {
                b += (double)array[j++];
                g += (double)array[j++];
                r += (double)array[j++];
                ++j;
                ++i;
            }
            double d = (0.299 * r + 0.587 * g + 0.114 * b) / (irisSize * irisSize);
            return d;
        }
        finally {
            if (tmp != null) {
                tmp.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DepthMapChannel {
        LUMINANCE,
        RED,
        GREEN,
        BLUE,
        ALPHA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IrisShape {
        TRIANGLE,
        SQUARE,
        PENTAGON,
        HEXAGON,
        HEPTAGON,
        OCTAGON,
        IRIS_LAYER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RadiusLimit {
        NONE,
        LIMIT20,
        LIMIT40,
        LIMIT60,
        LIMIT80;

    }
}

