/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IConvolutionSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.Sharpen", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class Sharpen {
    @Property(value="0", min="0")
    private IAnimatableDouble sharpenAmount;
    private final IVideoEffectContext context;
    private final IConvolutionSupport convolution;

    @Inject
    public Sharpen(IVideoEffectContext context, IConvolutionSupport convolution) {
        this.context = context;
        this.convolution = convolution;
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        double sharpenAmount = (Double)this.context.value((IAnimatableValue)this.sharpenAmount) / 20.0;
        if (sharpenAmount == 0.0) {
            return source;
        }
        float a = (float)(-sharpenAmount / 9.0);
        float b = (float)(1.0 + 8.0 * sharpenAmount / 9.0);
        float[] kernel = new float[]{a, a, a, a, b, a, a, a, a};
        try {
            source.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
            IVideoBuffer iVideoBuffer = this.convolution.convolve2D(source, null, 3, kernel);
            return iVideoBuffer;
        }
        finally {
            source.dispose();
        }
    }
}

