/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.distort;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.DisplacementMap", category="ch.kuramo.javie.api.effectCategory.distort")
public class DisplacementMap {
    @Property
    private IAnimatableLayerReference displacementMapLayer;
    @Property(value="RED")
    private IAnimatableEnum<UseForDisplacement> useForHorizontalDisplacement;
    @Property(value="5", min="-32000", max="32000")
    private IAnimatableDouble maxHorizontalDisplacement;
    @Property(value="GREEN")
    private IAnimatableEnum<UseForDisplacement> useForVerticalDisplacement;
    @Property(value="5", min="-32000", max="32000")
    private IAnimatableDouble maxVerticalDisplacement;
    @Property
    private IAnimatableEnum<MapPlacement> mapPlacement;
    @Property
    private IAnimatableEnum<WrapPixelsAround> wrapPixelsAround;
    @Property
    private IAnimatableBoolean expandOutput;
    @Property(value="true")
    private IAnimatableBoolean interpolation;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderRegistry shaders;
    private static final String RGB2HSL = "ch.kuramo.javie.effects.keying.KeyingShaders.rgb2hsl";

    @Inject
    public DisplacementMap(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.shaders = shaders;
    }

    private VideoBounds expandBounds(VideoBounds sourceBounds, double maxHorzDisplacement, double maxVertDisplacement) {
        maxHorzDisplacement = Math.abs(maxHorzDisplacement);
        maxVertDisplacement = Math.abs(maxVertDisplacement);
        double left = sourceBounds.x + (double)((int)Math.floor(-maxHorzDisplacement));
        double top = sourceBounds.y + (double)((int)Math.floor(-maxVertDisplacement));
        double right = sourceBounds.x + (double)sourceBounds.width + maxHorzDisplacement;
        double bottom = sourceBounds.y + (double)sourceBounds.height + maxVertDisplacement;
        return new VideoBounds(left, top, (int)Math.ceil(right - left), (int)Math.ceil(bottom - top));
    }

    public VideoBounds getVideoBounds() {
        boolean expandOutput;
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        MapPlacement mapPlacement = (MapPlacement)((Object)this.context.value(this.mapPlacement));
        boolean bl = expandOutput = mapPlacement == MapPlacement.TILE || mapPlacement == MapPlacement.MIRRORED_TILE ? (Boolean)this.context.value((IAnimatableValue)this.expandOutput) : false;
        if (expandOutput) {
            Resolution resolution = this.context.getVideoResolution();
            UseForDisplacement useForHorz = (UseForDisplacement)((Object)this.context.value(this.useForHorizontalDisplacement));
            UseForDisplacement useForVert = (UseForDisplacement)((Object)this.context.value(this.useForVerticalDisplacement));
            double maxHorzDisplacement = useForHorz == UseForDisplacement.OFF ? 0.0 : resolution.scale(((Double)this.context.value((IAnimatableValue)this.maxHorizontalDisplacement)).doubleValue());
            double maxVertDisplacement = useForVert == UseForDisplacement.OFF ? 0.0 : resolution.scale(((Double)this.context.value((IAnimatableValue)this.maxVerticalDisplacement)).doubleValue());
            return this.expandBounds(bounds, maxHorzDisplacement, maxVertDisplacement);
        }
        return bounds;
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        UseForDisplacement useForHorz = (UseForDisplacement)((Object)this.context.value(this.useForHorizontalDisplacement));
        UseForDisplacement useForVert = (UseForDisplacement)((Object)this.context.value(this.useForVerticalDisplacement));
        double maxHorzDisplacement = useForHorz == UseForDisplacement.OFF ? 0.0 : resolution.scale(((Double)this.context.value((IAnimatableValue)this.maxHorizontalDisplacement)).doubleValue());
        double maxVertDisplacement = useForVert == UseForDisplacement.OFF ? 0.0 : resolution.scale(((Double)this.context.value((IAnimatableValue)this.maxVerticalDisplacement)).doubleValue());
        MapPlacement mapPlacement = (MapPlacement)((Object)this.context.value(this.mapPlacement));
        boolean expandOutput = mapPlacement == MapPlacement.TILE || mapPlacement == MapPlacement.MIRRORED_TILE ? (Boolean)this.context.value((IAnimatableValue)this.expandOutput) : false;
        VideoBounds outputBounds = expandOutput ? this.expandBounds(bounds, maxHorzDisplacement, maxVertDisplacement) : bounds;
        IVideoBuffer mapBuffer = null;
        IVideoBuffer buffer = null;
        try {
            mapBuffer = this.context.getLayerVideoFrame(this.displacementMapLayer);
            if (mapBuffer == null) {
                if (expandOutput) {
                    buffer = this.support.createVideoBuffer(outputBounds);
                    buffer.clear();
                    this.support.copy(source, buffer);
                    IVideoBuffer result = buffer;
                    buffer = null;
                    IVideoBuffer iVideoBuffer = result;
                    return iVideoBuffer;
                }
                IVideoBuffer result = source;
                source = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            buffer = this.support.createVideoBuffer(outputBounds);
            buffer.clear();
            WrapPixelsAround wrapPixelsAround = (WrapPixelsAround)((Object)this.context.value(this.wrapPixelsAround));
            boolean interpolation = (Boolean)this.context.value((IAnimatableValue)this.interpolation);
            Quality quality = this.context.getQuality();
            source.setTextureWrapMode(wrapPixelsAround == WrapPixelsAround.CLAMP_TO_EDGE ? IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE : (wrapPixelsAround == WrapPixelsAround.REPEAT ? IVideoBuffer.TextureWrapMode.REPEAT : (wrapPixelsAround == WrapPixelsAround.MIRRORED_REPEAT ? IVideoBuffer.TextureWrapMode.MIRRORED_REPEAT : IVideoBuffer.TextureWrapMode.CLAMP_TO_BORDER)));
            source.setTextureFilter(quality == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : (interpolation ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR));
            mapBuffer.setTextureFilter(quality == Quality.DRAFT || resolution.scale < 1.0 ? IVideoBuffer.TextureFilter.NEAREST : (interpolation ? IVideoBuffer.TextureFilter.MIPMAP : IVideoBuffer.TextureFilter.LINEAR));
            IShaderProgram program = this.getProgram(useForHorz, useForVert, mapPlacement);
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("mapBuffer", 1));
            uniforms.add(new GLUniformData("size0", 2, this.toFloatBuffer(bounds.width, bounds.height)));
            uniforms.add(new GLUniformData("maxDisplacement", 2, this.toFloatBuffer(maxHorzDisplacement, maxVertDisplacement)));
            if (mapPlacement == MapPlacement.TILE || mapPlacement == MapPlacement.MIRRORED_TILE) {
                uniforms.add(new GLUniformData("offset0", 2, this.toFloatBuffer(outputBounds.x - bounds.x, outputBounds.y - bounds.y)));
                mapBuffer.setTextureWrapMode(mapPlacement == MapPlacement.TILE ? IVideoBuffer.TextureWrapMode.REPEAT : IVideoBuffer.TextureWrapMode.MIRRORED_REPEAT);
            }
            if (mapPlacement != MapPlacement.STRETCH) {
                VideoBounds mapBounds = mapBuffer.getBounds();
                uniforms.add(new GLUniformData("size1", 2, this.toFloatBuffer(mapBounds.width, mapBounds.height)));
            }
            this.support.useShaderProgram(program, uniforms, buffer, new IVideoBuffer[]{source, mapBuffer});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            if (mapBuffer != null) {
                mapBuffer.dispose();
            }
            if (source != null) {
                source.dispose();
            }
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] farray = new float[values.length];
        int i = 0;
        while (i < values.length) {
            farray[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(farray);
    }

    private IShaderProgram getProgram(UseForDisplacement useForHorz, UseForDisplacement useForVert, MapPlacement mapPlacement) {
        String programName = String.valueOf(DisplacementMap.class.getName()) + "." + useForHorz.name() + "." + useForVert.name() + "." + mapPlacement.name();
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            String[] source = this.createShaderSource(useForHorz, useForVert, mapPlacement);
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, new String[]{RGB2HSL}, source);
        }
        return program;
    }

    private String[] createShaderSource(UseForDisplacement useForHorz, UseForDisplacement useForVert, MapPlacement mapPlacement) {
        boolean stretch = mapPlacement == MapPlacement.STRETCH;
        boolean center = mapPlacement == MapPlacement.CENTER;
        boolean tile = mapPlacement == MapPlacement.TILE || mapPlacement == MapPlacement.MIRRORED_TILE;
        return new String[]{"#define USE_FOR_HORZ " + useForHorz.ordinal(), "#define USE_FOR_VERT " + useForVert.ordinal(), stretch ? "#define STRETCH" : "", center ? "#define CENTER" : "", tile ? "#define TILE" : "", "", "uniform sampler2D texture;", "uniform vec2 size0;", "uniform sampler2D mapBuffer;", "uniform vec2 maxDisplacement;", "", "#ifdef TILE", "\tuniform vec2 offset0;", "#endif", "#ifndef STRETCH", "\tuniform vec2 size1;", "#endif", "", "const vec3 lumaVec = vec3(0.299, 0.587, 0.114);", "", "vec3 rgb2hsl(vec3 rgb);", "", "vec2 mapValue(vec4 mapColor)", "{", "\tvec2 value = vec2(0.0);", "", "#if USE_FOR_HORZ == " + UseForDisplacement.RED.ordinal(), "\tvalue.x = (mapColor.a > 0.0) ? (mapColor.r/mapColor.a*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_HORZ == " + UseForDisplacement.GREEN.ordinal(), "\tvalue.x = (mapColor.a > 0.0) ? (mapColor.g/mapColor.a*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_HORZ == " + UseForDisplacement.BLUE.ordinal(), "\tvalue.x = (mapColor.a > 0.0) ? (mapColor.b/mapColor.a*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_HORZ == " + UseForDisplacement.ALPHA.ordinal(), "\tvalue.x = mapColor.a*2.0-1.0;", "#elif USE_FOR_HORZ == " + UseForDisplacement.LUMINANCE.ordinal(), "\tvalue.x = (mapColor.a > 0.0) ? (dot(mapColor.rgb/mapColor.a, lumaVec)*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_HORZ == " + UseForDisplacement.HUE.ordinal(), "\tvalue.x = (mapColor.a > 0.0) ? (rgb2hsl(mapColor.rgb/mapColor.a).x*2.0-1.0) : 0.0;", "#elif USE_FOR_HORZ == " + UseForDisplacement.LIGHTNESS.ordinal(), "\tvalue.x = (mapColor.a > 0.0) ? (rgb2hsl(mapColor.rgb/mapColor.a).z*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_HORZ == " + UseForDisplacement.SATURATION.ordinal(), "\tvalue.x = (mapColor.a > 0.0) ? (rgb2hsl(mapColor.rgb/mapColor.a).y*2.0-1.0)*mapColor.a : 0.0;", "#endif", "", "#if USE_FOR_VERT == " + UseForDisplacement.RED.ordinal(), "\tvalue.y = (mapColor.a > 0.0) ? (mapColor.r/mapColor.a*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_VERT == " + UseForDisplacement.GREEN.ordinal(), "\tvalue.y = (mapColor.a > 0.0) ? (mapColor.g/mapColor.a*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_VERT == " + UseForDisplacement.BLUE.ordinal(), "\tvalue.y = (mapColor.a > 0.0) ? (mapColor.b/mapColor.a*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_VERT == " + UseForDisplacement.ALPHA.ordinal(), "\tvalue.y = mapColor.a*2.0-1.0;", "#elif USE_FOR_VERT == " + UseForDisplacement.LUMINANCE.ordinal(), "\tvalue.y = (mapColor.a > 0.0) ? (dot(mapColor.rgb/mapColor.a, lumaVec)*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_VERT == " + UseForDisplacement.HUE.ordinal(), "\tvalue.y = (mapColor.a > 0.0) ? (rgb2hsl(mapColor.rgb/mapColor.a).x*2.0-1.0) : 0.0;", "#elif USE_FOR_VERT == " + UseForDisplacement.LIGHTNESS.ordinal(), "\tvalue.y = (mapColor.a > 0.0) ? (rgb2hsl(mapColor.rgb/mapColor.a).z*2.0-1.0)*mapColor.a : 0.0;", "#elif USE_FOR_VERT == " + UseForDisplacement.SATURATION.ordinal(), "\tvalue.y = (mapColor.a > 0.0) ? (rgb2hsl(mapColor.rgb/mapColor.a).y*2.0-1.0)*mapColor.a : 0.0;", "#endif", "", "\treturn value;", "}", "", "void main(void)", "{", "#ifdef STRETCH", "\tvec2 tc = gl_TexCoord[0].st;", "\tvec4 mapColor = texture2D(mapBuffer, tc);", "\tvec2 displacement = mapValue(mapColor) * maxDisplacement;", "#endif", "", "#ifdef CENTER", "\tvec2 tc = ((gl_FragCoord.xy - 0.5*size0) / size1) + vec2(0.5);", "\tvec4 mapColor = texture2D(mapBuffer, tc);", "\tvec2 displacement;", "\tif (all(greaterThanEqual(tc, vec2(0.0))) && all(lessThanEqual(tc, vec2(1.0)))) {", "\t\tdisplacement = mapValue(mapColor) * maxDisplacement;", "\t} else {", "\t\tdisplacement = vec2(0.0);", "\t}", "#endif", "", "#ifdef TILE", "\tvec2 tc = ((gl_FragCoord.xy + offset0 - 0.5*size0) / size1) + vec2(0.5);", "\tvec4 mapColor = texture2D(mapBuffer, tc);", "\tvec2 displacement = mapValue(mapColor) * maxDisplacement;", "#endif", "", "#ifndef STRETCH", "\ttc = gl_TexCoord[0].st;", "#endif", "", "\tgl_FragColor = texture2D(texture, tc + displacement/size0);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MapPlacement {
        STRETCH,
        CENTER,
        TILE,
        MIRRORED_TILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UseForDisplacement {
        RED,
        GREEN,
        BLUE,
        ALPHA,
        LUMINANCE,
        HUE,
        LIGHTNESS,
        SATURATION,
        OFF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WrapPixelsAround {
        NONE,
        CLAMP_TO_EDGE,
        REPEAT,
        MIRRORED_REPEAT;

    }
}

