/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ca.uol.aig.fftpack.RealDoubleFFT;
import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.generate.AudioDrawing;
import com.google.inject.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.AudioSpectrum", category="ch.kuramo.javie.api.effectCategory.generate")
public class AudioSpectrum
extends AudioDrawing {
    @Property
    private IAnimatableLayerReference audioLayer;
    @Property
    private IAnimatableVec2d startPoint;
    @Property
    private IAnimatableVec2d endPoint;
    @Property(value="20", min="1", max="48000")
    private IAnimatableDouble startFrequency;
    @Property(value="2000", min="1", max="48000")
    private IAnimatableDouble endFrequency;
    @Property(value="64", min="1", max="4096")
    private IAnimatableInteger frequencyBands;
    @Property(value="120", min="1")
    private IAnimatableDouble height;
    @Property(value="90", min="0", max="30000")
    private IAnimatableDouble audioDuration;
    @Property(value="0", min="-30000", max="30000")
    private IAnimatableDouble audioOffset;
    @Property(value="3", min="0", max="100")
    private IAnimatableDouble thickness;
    @Property(value="0,1,0")
    private IAnimatableColor color;
    @Property(value="MONO")
    private IAnimatableEnum<AudioDrawing.Channel> channel;
    @Property(value="BARS")
    private IAnimatableEnum<AudioDrawing.Style> style;
    @Property(value="true")
    private IAnimatableBoolean smoothing;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IArrayPools arrayPools;

    @Inject
    public AudioSpectrum(IVideoEffectContext context, IVideoRenderSupport support, IBlendSupport blendSupport, IArrayPools arrayPools) {
        super(context, support, blendSupport);
        this.arrayPools = arrayPools;
    }

    public IVideoBuffer doVideoEffect() {
        AudioDrawing.DataProvider dp = new AudioDrawing.DataProvider(){
            private int freqBands;
            private IArray<double[]> bands;
            private double[] bandsArray;

            public void init() {
                this.freqBands = (Integer)AudioSpectrum.this.context.value((IAnimatableValue)AudioSpectrum.this.frequencyBands);
                this.bands = AudioSpectrum.this.arrayPools.getDoubleArray(this.freqBands);
                this.bandsArray = (double[])this.bands.getArray();
                double duration = (Double)AudioSpectrum.this.context.value((IAnimatableValue)AudioSpectrum.this.audioDuration) / 1000.0;
                double offset = (Double)AudioSpectrum.this.context.value((IAnimatableValue)AudioSpectrum.this.audioOffset) / 1000.0;
                AudioMode audioMode = AudioSpectrum.this.context.getAudioMode();
                Time startOffset = new Time((long)((offset - duration / 2.0) * (double)audioMode.sampleRate), audioMode.sampleRate);
                Time startTime = startOffset.add(AudioSpectrum.this.context.getTime());
                int audioFrameCount = (int)(duration * (double)audioMode.sampleRate);
                audioFrameCount = (audioFrameCount + 3) / 4 * 4;
                AudioSpectrum.this.context.setTime(startTime);
                AudioSpectrum.this.context.setAudioFrameCount(audioFrameCount);
                IAudioBuffer audio = null;
                try {
                    audio = AudioSpectrum.this.context.getLayerAudioChunk(AudioSpectrum.this.audioLayer);
                    if (audio == null) {
                        this.bands.clear();
                    } else {
                        double startFreq = (Double)AudioSpectrum.this.context.value((IAnimatableValue)AudioSpectrum.this.startFrequency);
                        double endFreq = Math.max(startFreq, (Double)AudioSpectrum.this.context.value((IAnimatableValue)AudioSpectrum.this.endFrequency));
                        AudioDrawing.Channel ch = (AudioDrawing.Channel)((Object)AudioSpectrum.this.context.value((IAnimatableValue)AudioSpectrum.this.channel));
                        AudioSpectrum.this.fft(audio, (IArray<double[]>)this.bands, startFreq, endFreq, ch);
                    }
                }
                finally {
                    if (audio != null) {
                        audio.dispose();
                    }
                }
            }

            public void dispose() {
                if (this.bands != null) {
                    this.bands.release();
                    this.bands = null;
                }
            }

            public int getDataCount() {
                return this.freqBands;
            }

            public float getDataLower(int index) {
                return 0.0f;
            }

            public float getDataUpper(int index) {
                return (float)(-this.bandsArray[index]);
            }

            public float getData(int index) {
                return (float)(-this.bandsArray[index]);
            }
        };
        return this.draw(dp, this.startPoint, this.endPoint, this.height, this.thickness, this.color, this.style, this.smoothing, this.blendMode, this.opacity);
    }

    private void fft(IAudioBuffer audio, IArray<double[]> bands, double startFreq, double endFreq, AudioDrawing.Channel channel) {
        int n = audio.getFrameCount();
        RealDoubleFFT fft = new RealDoubleFFT(n);
        IArray fftData = null;
        try {
            double f;
            int j;
            fftData = this.arrayPools.getDoubleArray(n);
            double[] fftDataArray = (double[])fftData.getArray();
            switch (audio.getAudioMode().dataType) {
                case SHORT: {
                    Object[] audioArray = (short[])audio.getData();
                    double left = channel == AudioDrawing.Channel.RIGHT ? 0.0 : 3.051850947599719E-5;
                    double right = channel == AudioDrawing.Channel.LEFT ? 0.0 : 3.051850947599719E-5;
                    int i = 0;
                    while (i < n) {
                        fftDataArray[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))) * (left * (double)audioArray[i * 2] + right * (double)audioArray[i * 2 + 1]);
                        ++i;
                    }
                    break;
                }
                case INT: {
                    Object[] audioArray = (int[])audio.getData();
                    double left = channel == AudioDrawing.Channel.RIGHT ? 0.0 : 4.656612875245797E-10;
                    double right = channel == AudioDrawing.Channel.LEFT ? 0.0 : 4.656612875245797E-10;
                    int i = 0;
                    while (i < n) {
                        fftDataArray[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))) * (left * (double)audioArray[i * 2] + right * (double)audioArray[i * 2 + 1]);
                        ++i;
                    }
                    break;
                }
                case FLOAT: {
                    Object[] audioArray = (float[])audio.getData();
                    double left = channel != AudioDrawing.Channel.RIGHT ? 1 : 0;
                    double right = channel != AudioDrawing.Channel.LEFT ? 1 : 0;
                    int i = 0;
                    while (i < n) {
                        fftDataArray[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))) * (left * (double)audioArray[i * 2] + right * (double)audioArray[i * 2 + 1]);
                        ++i;
                    }
                    break;
                }
            }
            fft.ft(fftDataArray, n);
            bands.clear();
            int numBands = bands.getLength();
            double[] bandsArray = (double[])bands.getArray();
            double bandWidth = (endFreq - startFreq) / (double)numBands;
            double baseFreq = (double)audio.getAudioMode().sampleRate / (double)n;
            int i = 1;
            while (i < n - 1) {
                double f2 = (double)((i + 1) / 2) * baseFreq;
                int j2 = (int)Math.floor((f2 - startFreq) / bandWidth);
                if (j2 >= 0 && j2 < numBands) {
                    double a = fftDataArray[i] / (double)n * 2.0;
                    double b = fftDataArray[i + 1] / (double)n * 2.0;
                    int n2 = j2;
                    bandsArray[n2] = bandsArray[n2] + (a * a + b * b);
                }
                i += 2;
            }
            if (n % 2 == 0 && (j = (int)Math.floor(((f = (double)(n / 2) * baseFreq) - startFreq) / bandWidth)) >= 0 && j < numBands) {
                double a = fftDataArray[n - 1] / (double)n * 2.0;
                int n3 = j;
                bandsArray[n3] = bandsArray[n3] + a * a;
            }
            i = 0;
            while (i < numBands) {
                bandsArray[i] = 10.0 * Math.sqrt(bandsArray[i]);
                ++i;
            }
        }
        finally {
            if (fftData != null) {
                fftData.release();
            }
        }
    }
}

