/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.FrameDuration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class TimeCode {
    private static final Pattern NON_NUMBER = Pattern.compile("[^\\d]");

    public static String toTimeCode(Time time, Time frameDuration) {
        return TimeCode.toTimeCode(time, frameDuration, true, true);
    }

    public static String toTimeCode(Time time, Time frameDuration, boolean dropFrame, boolean withZeroHour) {
        if (frameDuration.equals((Object)FrameDuration.FPS_59_94)) {
            return TimeCode.toTimeCode(time, frameDuration, 60, dropFrame ? 4 : 0, withZeroHour);
        }
        if (frameDuration.equals((Object)FrameDuration.FPS_29_97)) {
            return TimeCode.toTimeCode(time, frameDuration, 30, dropFrame ? 2 : 0, withZeroHour);
        }
        double fps = (double)frameDuration.timeScale / (double)frameDuration.timeValue;
        String fpsStr = String.format("%.2f", fps);
        if (fpsStr.equals("59.94")) {
            return TimeCode.toTimeCode(time, frameDuration, 60, dropFrame ? 4 : 0, withZeroHour);
        }
        if (fpsStr.equals("29.97")) {
            return TimeCode.toTimeCode(time, frameDuration, 30, dropFrame ? 2 : 0, withZeroHour);
        }
        return TimeCode.toTimeCode(time, frameDuration, (int)Math.round(fps), 0, withZeroHour);
    }

    private static String toTimeCode(Time time, Time frameDuration, int base, int drop, boolean withZeroHour) {
        String timeCode;
        boolean negative;
        long frames = time.toFrameNumber(frameDuration);
        boolean bl = negative = frames < 0L;
        if (negative) {
            frames = -frames;
        }
        long fpm = base * 60 - drop;
        long fp10m = fpm * 10L + (long)drop;
        long fph = fp10m * 6L;
        long h = frames / fph;
        long tenm = (frames %= fph) / fp10m;
        long m = (frames %= fp10m) / fpm;
        long s = (frames %= fpm) / (long)base;
        frames %= (long)base;
        if (drop == 0) {
            timeCode = withZeroHour || h != 0L ? String.format("%d:%01d%01d:%02d:%02d", h, tenm, m, s, frames) : String.format("%01d%01d:%02d:%02d", tenm, m, s, frames);
        } else {
            if (s == 0L && m != 0L && frames < (long)drop) {
                --m;
                s = 59L;
                frames += (long)(base - drop);
            }
            String string = timeCode = withZeroHour || h != 0L ? String.format("%d;%01d%01d;%02d;%02d", h, tenm, m, s, frames) : String.format("%01d%01d;%02d;%02d", tenm, m, s, frames);
        }
        if (negative) {
            return "-" + timeCode;
        }
        return timeCode;
    }

    public static long parseTimeCode(String timeCode, Time frameDuration) {
        return TimeCode.parseTimeCode(timeCode, frameDuration, true);
    }

    public static long parseTimeCode(String timeCode, Time frameDuration, boolean dropFrame) {
        if (frameDuration.equals((Object)FrameDuration.FPS_59_94)) {
            return TimeCode.parseTimeCode(timeCode, 60, dropFrame ? 4 : 0);
        }
        if (frameDuration.equals((Object)FrameDuration.FPS_29_97)) {
            return TimeCode.parseTimeCode(timeCode, 30, dropFrame ? 2 : 0);
        }
        double fps = (double)frameDuration.timeScale / (double)frameDuration.timeValue;
        String fpsStr = String.format("%.2f", fps);
        if (fpsStr.equals("59.94")) {
            return TimeCode.parseTimeCode(timeCode, 60, dropFrame ? 4 : 0);
        }
        if (fpsStr.equals("29.97")) {
            return TimeCode.parseTimeCode(timeCode, 30, dropFrame ? 2 : 0);
        }
        int base = (int)Math.round((double)frameDuration.timeScale / (double)frameDuration.timeValue);
        return TimeCode.parseTimeCode(timeCode, base, 0);
    }

    private static long parseTimeCode(String timeCode, int base, int drop) {
        boolean negative;
        boolean bl = negative = (timeCode = timeCode.trim()).charAt(0) == '-';
        if (negative) {
            timeCode = timeCode.substring(1);
        }
        long fpm = base * 60 - drop;
        long fp10m = fpm * 10L + (long)drop;
        long fph = fp10m * 6L;
        List<String> numbers = Arrays.asList(NON_NUMBER.split(timeCode));
        if (numbers.isEmpty()) {
            return 0L;
        }
        Collections.reverse(numbers);
        long frames = 0L;
        String str = numbers.get(0);
        if (str.length() > 0) {
            frames += Long.parseLong(str);
        }
        if (numbers.size() == 1) {
            return negative ? -frames : frames;
        }
        str = numbers.get(1);
        if (str.length() > 0) {
            long s = Long.parseLong(str);
            long m = s / 60L;
            frames += s % 60L * (long)base;
            long tenm = m / 10L;
            frames += m % 10L * fpm;
            long h = tenm / 6L;
            frames += tenm % 6L * fp10m;
            frames += h * fph;
        }
        if (numbers.size() == 2) {
            return negative ? -frames : frames;
        }
        str = numbers.get(2);
        if (str.length() > 0) {
            long m = Long.parseLong(str);
            long tenm = m / 10L;
            frames += m % 10L * fpm;
            long h = tenm / 6L;
            frames += tenm % 6L * fp10m;
            frames += h * fph;
        }
        if (numbers.size() == 3) {
            return negative ? -frames : frames;
        }
        str = numbers.get(3);
        if (str.length() > 0) {
            long h = Long.parseLong(str);
            frames += h * fph;
        }
        return negative ? -frames : frames;
    }
}

