/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.expression;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.expression.ExpressionUtils;
import java.util.Random;
import noise.ImprovedNoise;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class RandomNumbers {
    public static final String[] METHOD_NAMES = new String[]{"seedRandom", "random", "gaussRandom", "noise", "wiggle1", "wiggle2", "wiggle3", "wiggle"};
    private static final double[] DOUBLE_0 = new double[]{0.0};
    private static final double[] DOUBLE_00 = new double[]{0.0, 0.0};
    private static final double[] DOUBLE_000 = new double[]{0.0, 0.0, 0.0};
    private long seed;
    private boolean timeless;
    private final Time time;
    private Random random;

    public static Object seedRandom(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        Number seed;
        Boolean timeless = Boolean.FALSE;
        switch (args.length) {
            case 2: {
                timeless = (Boolean)Context.jsToJava((Object)args[1], Boolean.TYPE);
            }
            case 1: {
                seed = (Number)Context.jsToJava((Object)args[0], Number.class);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        RandomNumbers rn = (RandomNumbers)cx.getThreadLocal(RandomNumbers.class);
        rn.seedRandom(seed.longValue(), timeless);
        return Context.getUndefinedValue();
    }

    public static Object random(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return RandomNumbers.random(cx, args, false);
    }

    public static Object gaussRandom(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return RandomNumbers.random(cx, args, true);
    }

    private static Object random(Context cx, Object[] args, boolean gaussian) {
        double[] dArray;
        double[] a1;
        double[] dArray2;
        Object o1 = 0.0;
        Object o2 = 1.0;
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                o2 = ExpressionUtils.toDoubleOrDoubleArray(args[0]);
                break;
            }
            default: {
                o1 = ExpressionUtils.toDoubleOrDoubleArray(args[0]);
                o2 = ExpressionUtils.toDoubleOrDoubleArray(args[1]);
            }
        }
        RandomNumbers rn = (RandomNumbers)cx.getThreadLocal(RandomNumbers.class);
        Random r = rn.getRandom();
        if (o1 instanceof Double && o2 instanceof Double) {
            double min = (Double)o1;
            double max = (Double)o2;
            return RandomNumbers.random(r, min, max, gaussian);
        }
        if (o1 instanceof Double) {
            double[] dArray3 = new double[1];
            dArray2 = dArray3;
            dArray3[0] = (Double)o1;
        } else {
            dArray2 = a1 = (double[])o1;
        }
        if (o2 instanceof Double) {
            double[] dArray4 = new double[1];
            dArray = dArray4;
            dArray4[0] = (Double)o2;
        } else {
            dArray = (double[])o2;
        }
        double[] a2 = dArray;
        double[] a = new double[Math.max(a1.length, a2.length)];
        int i = 0;
        while (i < a.length) {
            double min = i < a1.length ? a1[i] : 1.0;
            double max = i < a2.length ? a2[i] : 0.0;
            a[i] = RandomNumbers.random(r, min, max, gaussian);
            ++i;
        }
        return a;
    }

    private static double random(Random r, double min, double max, boolean gaussian) {
        double d = gaussian ? r.nextGaussian() / 3.2894 + 0.5 : (double)r.nextFloat();
        return d * (max - min) + min;
    }

    public static double noise(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        double d1;
        double d2;
        double d0;
        if (args.length != 1) {
            throw new IllegalArgumentException();
        }
        Object o = ExpressionUtils.toDoubleOrDoubleArray(args[0]);
        if (o instanceof Double) {
            d0 = (Double)o;
            d2 = 0.0;
            d1 = 0.0;
        } else {
            double[] array = (double[])o;
            d0 = array.length >= 1 ? array[0] : 0.0;
            d1 = array.length >= 2 ? array[1] : 0.0;
            d2 = array.length >= 3 ? array[2] : 0.0;
        }
        return ImprovedNoise.noise(d0 + 0.2356, d1 + 0.6049, d2 + 0.7724);
    }

    public static Object wiggle1(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return RandomNumbers.wiggle(cx, args, DOUBLE_0)[0];
    }

    public static Object wiggle2(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return RandomNumbers.wiggle(cx, args, DOUBLE_00);
    }

    public static Object wiggle3(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return RandomNumbers.wiggle(cx, args, DOUBLE_000);
    }

    public static Object wiggle(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        if (args.length < 3 || args.length > 5) {
            throw new IllegalArgumentException();
        }
        Object values = ExpressionUtils.toDoubleOrDoubleArray(args[0]);
        Object[] args2 = new Object[args.length - 1];
        System.arraycopy(args, 1, args2, 0, args2.length);
        if (values instanceof Double) {
            return RandomNumbers.wiggle(cx, args2, new double[]{(Double)values})[0];
        }
        return RandomNumbers.wiggle(cx, args2, (double[])values);
    }

    private static double[] wiggle(Context cx, Object[] args, double[] values) {
        if (args.length < 2 || args.length > 4) {
            throw new IllegalArgumentException();
        }
        double freq = (Double)Context.jsToJava((Object)args[0], Double.TYPE);
        double amp = (Double)Context.jsToJava((Object)args[1], Double.TYPE);
        int octaves = args.length >= 3 ? (int)Math.ceil((Double)Context.jsToJava((Object)args[2], Double.TYPE)) : 1;
        double ampMult = args.length >= 4 ? (Double)Context.jsToJava((Object)args[3], Double.TYPE) : 0.5;
        RandomNumbers rn = (RandomNumbers)cx.getThreadLocal(RandomNumbers.class);
        return RandomNumbers.wiggle(freq, amp, octaves, ampMult, rn, rn.time.toSecond(), values);
    }

    private static double[] wiggle(double freq, double amp, int octaves, double ampMult, RandomNumbers rn, double time, double[] values) {
        double[] result = new double[values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = values[i];
            ++i;
        }
        i = 0;
        while (i < octaves) {
            double t = time * freq;
            int j = 0;
            while (j < result.length) {
                int n = j;
                result[n] = result[n] + amp * ImprovedNoise.noise(0.2356 + (double)rn.seed, 0.6049 + t, 0.7724 + (double)(73 * (j + 1)));
                ++j;
            }
            ++i;
            amp *= ampMult;
            freq *= 2.0;
        }
        return result;
    }

    static double[] wiggle(double freq, double amp, double octaves, double ampMult, double[] values) {
        Context cx = Context.getCurrentContext();
        RandomNumbers rn = (RandomNumbers)cx.getThreadLocal(RandomNumbers.class);
        return RandomNumbers.wiggle(freq, amp, (int)Math.ceil(octaves), ampMult, rn, rn.time.toSecond(), values);
    }

    static double[] wiggle(double freq, double amp, double octaves, double ampMult, double t, double[] values) {
        Context cx = Context.getCurrentContext();
        RandomNumbers rn = (RandomNumbers)cx.getThreadLocal(RandomNumbers.class);
        return RandomNumbers.wiggle(freq, amp, (int)Math.ceil(octaves), ampMult, rn, t, values);
    }

    public RandomNumbers(long seed, Time time) {
        this.seed = seed;
        this.time = time;
    }

    private Random getRandom() {
        if (this.random == null) {
            this.random = new Random(this.seed + (this.timeless ? 0L : this.time.timeValue));
            this.random.nextFloat();
        }
        return this.random;
    }

    private void seedRandom(long seed, boolean timeless) {
        this.seed = seed;
        this.timeless = timeless;
        this.random = null;
    }
}

