/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.AbstractAnimatableEnum;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Expressionee;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.TAProperty;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.annotations.ProjectElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProjectElement(value="textAnimator")
public class TextAnimatorImpl
implements TextAnimator {
    private boolean enabled = true;
    private String name = "\u30a2\u30cb\u30e1\u30fc\u30bf";
    private List<TASelector> selectors = Util.newList();
    private Set<TAProperty> properties = Util.newSet();
    private AnimatableVec3d anchorPoint = new AnimatableVec3d(Vec3d.ZERO);
    private AnimatableVec3d position = new AnimatableVec3d(Vec3d.ZERO);
    private AnimatableVec3d scale = new AnimatableVec3d(new Vec3d(100.0, 100.0, 100.0));
    private AnimatableDouble skew = new AnimatableDouble((Double)0.0, -70.0, 70.0);
    private AnimatableDouble skewAxis = new AnimatableDouble(0.0);
    private AnimatableDouble rotationX = new AnimatableDouble(0.0);
    private AnimatableDouble rotationY = new AnimatableDouble(0.0);
    private AnimatableDouble rotationZ = new AnimatableDouble(0.0);
    private AnimatableDouble opacity = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private AnimatableColor fillRGB = new AnimatableColor(Color.WHITE);
    private AnimatableDouble fillHue = new AnimatableDouble(0.0);
    private AnimatableDouble fillSaturation = new AnimatableDouble((Double)0.0, -100.0, 100.0);
    private AnimatableDouble fillLuminosity = new AnimatableDouble((Double)0.0, -100.0, 100.0);
    private AnimatableDouble fillOpacity = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private AnimatableColor strokeRGB = new AnimatableColor(new Color(1.0, 0.0, 0.0));
    private AnimatableDouble strokeHue = new AnimatableDouble(0.0);
    private AnimatableDouble strokeSaturation = new AnimatableDouble((Double)0.0, -100.0, 100.0);
    private AnimatableDouble strokeLuminosity = new AnimatableDouble((Double)0.0, -100.0, 100.0);
    private AnimatableDouble strokeOpacity = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private AnimatableDouble strokeWidth = new AnimatableDouble((Double)0.0, -1000.0, 1000.0);
    private AnimatableDouble tracking = new AnimatableDouble(0.0);
    private AnimatableVec2d lineSpacing = new AnimatableVec2d(Vec2d.ZERO);
    private AnimatableCharacterRange characterRange = new AnimatableCharacterRange(TextAnimator.CharacterRange.GROUP);
    private AnimatableInteger characterValue = new AnimatableInteger((Integer)0, 0, 65535);
    private AnimatableInteger characterOffset = new AnimatableInteger(0);
    private AnimatableVec2d blur = new AnimatableVec2d(Vec2d.ZERO, Vec2d.ZERO, new Vec2d(500.0, 500.0));

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<TASelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<TASelector> selectors) {
        this.selectors = selectors;
    }

    @Override
    public Set<TAProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<TAProperty> properties) {
        this.properties = properties;
    }

    @Override
    public AnimatableVec3d getAnchorPoint() {
        return this.anchorPoint;
    }

    public void setAnchorPoint(AnimatableVec3d anchorPoint) {
        anchorPoint.copyConfigurationFrom(this.anchorPoint);
        this.anchorPoint = anchorPoint;
    }

    @Override
    public AnimatableVec3d getPosition() {
        return this.position;
    }

    public void setPosition(AnimatableVec3d position) {
        position.copyConfigurationFrom(this.position);
        this.position = position;
    }

    @Override
    public AnimatableVec3d getScale() {
        return this.scale;
    }

    public void setScale(AnimatableVec3d scale) {
        scale.copyConfigurationFrom(this.scale);
        this.scale = scale;
    }

    @Override
    public AnimatableDouble getSkew() {
        return this.skew;
    }

    public void setSkew(AnimatableDouble skew) {
        skew.copyConfigurationFrom(this.skew);
        this.skew = skew;
    }

    @Override
    public AnimatableDouble getSkewAxis() {
        return this.skewAxis;
    }

    public void setSkewAxis(AnimatableDouble skewAxis) {
        skewAxis.copyConfigurationFrom(this.skewAxis);
        this.skewAxis = skewAxis;
    }

    @Override
    public AnimatableDouble getRotationX() {
        return this.rotationX;
    }

    public void setRotationX(AnimatableDouble rotationX) {
        rotationX.copyConfigurationFrom(this.rotationX);
        this.rotationX = rotationX;
    }

    @Override
    public AnimatableDouble getRotationY() {
        return this.rotationY;
    }

    public void setRotationY(AnimatableDouble rotationY) {
        rotationY.copyConfigurationFrom(this.rotationY);
        this.rotationY = rotationY;
    }

    @Override
    public AnimatableDouble getRotationZ() {
        return this.rotationZ;
    }

    public void setRotationZ(AnimatableDouble rotationZ) {
        rotationZ.copyConfigurationFrom(this.rotationZ);
        this.rotationZ = rotationZ;
    }

    @Override
    public AnimatableDouble getOpacity() {
        return this.opacity;
    }

    public void setOpacity(AnimatableDouble opacity) {
        opacity.copyConfigurationFrom(this.opacity);
        this.opacity = opacity;
    }

    @Override
    public AnimatableColor getFillRGB() {
        return this.fillRGB;
    }

    public void setFillRGB(AnimatableColor fillRGB) {
        fillRGB.copyConfigurationFrom(this.fillRGB);
        this.fillRGB = fillRGB;
    }

    @Override
    public AnimatableDouble getFillHue() {
        return this.fillHue;
    }

    public void setFillHue(AnimatableDouble fillHue) {
        fillHue.copyConfigurationFrom(this.fillHue);
        this.fillHue = fillHue;
    }

    @Override
    public AnimatableDouble getFillSaturation() {
        return this.fillSaturation;
    }

    public void setFillSaturation(AnimatableDouble fillSaturation) {
        fillSaturation.copyConfigurationFrom(this.fillSaturation);
        this.fillSaturation = fillSaturation;
    }

    @Override
    public AnimatableDouble getFillLuminosity() {
        return this.fillLuminosity;
    }

    public void setFillLuminosity(AnimatableDouble fillLuminosity) {
        fillLuminosity.copyConfigurationFrom(this.fillLuminosity);
        this.fillLuminosity = fillLuminosity;
    }

    @Override
    public AnimatableDouble getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(AnimatableDouble fillOpacity) {
        fillOpacity.copyConfigurationFrom(this.fillOpacity);
        this.fillOpacity = fillOpacity;
    }

    @Override
    public AnimatableColor getStrokeRGB() {
        return this.strokeRGB;
    }

    public void setStrokeRGB(AnimatableColor strokeRGB) {
        strokeRGB.copyConfigurationFrom(this.strokeRGB);
        this.strokeRGB = strokeRGB;
    }

    @Override
    public AnimatableDouble getStrokeHue() {
        return this.strokeHue;
    }

    public void setStrokeHue(AnimatableDouble strokeHue) {
        strokeHue.copyConfigurationFrom(this.strokeHue);
        this.strokeHue = strokeHue;
    }

    @Override
    public AnimatableDouble getStrokeSaturation() {
        return this.strokeSaturation;
    }

    public void setStrokeSaturation(AnimatableDouble strokeSaturation) {
        strokeSaturation.copyConfigurationFrom(this.strokeSaturation);
        this.strokeSaturation = strokeSaturation;
    }

    @Override
    public AnimatableDouble getStrokeLuminosity() {
        return this.strokeLuminosity;
    }

    public void setStrokeLuminosity(AnimatableDouble strokeLuminosity) {
        strokeLuminosity.copyConfigurationFrom(this.strokeLuminosity);
        this.strokeLuminosity = strokeLuminosity;
    }

    @Override
    public AnimatableDouble getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public void setStrokeOpacity(AnimatableDouble strokeOpacity) {
        strokeOpacity.copyConfigurationFrom(this.strokeOpacity);
        this.strokeOpacity = strokeOpacity;
    }

    @Override
    public AnimatableDouble getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(AnimatableDouble strokeWidth) {
        strokeWidth.copyConfigurationFrom(this.strokeWidth);
        this.strokeWidth = strokeWidth;
    }

    @Override
    public AnimatableDouble getTracking() {
        return this.tracking;
    }

    public void setTracking(AnimatableDouble tracking) {
        tracking.copyConfigurationFrom(this.tracking);
        this.tracking = tracking;
    }

    @Override
    public AnimatableVec2d getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(AnimatableVec2d lineSpacing) {
        lineSpacing.copyConfigurationFrom(this.lineSpacing);
        this.lineSpacing = lineSpacing;
    }

    public AnimatableCharacterRange getCharacterRange() {
        return this.characterRange;
    }

    public void setCharacterRange(AnimatableCharacterRange characterRange) {
        characterRange.copyConfigurationFrom(this.characterRange);
        this.characterRange = characterRange;
    }

    @Override
    public AnimatableInteger getCharacterValue() {
        return this.characterValue;
    }

    public void setCharacterValue(AnimatableInteger characterValue) {
        characterValue.copyConfigurationFrom(this.characterValue);
        this.characterValue = characterValue;
    }

    @Override
    public AnimatableInteger getCharacterOffset() {
        return this.characterOffset;
    }

    public void setCharacterOffset(AnimatableInteger characterOffset) {
        characterOffset.copyConfigurationFrom(this.characterOffset);
        this.characterOffset = characterOffset;
    }

    @Override
    public AnimatableVec2d getBlur() {
        return this.blur;
    }

    public void setBlur(AnimatableVec2d blur) {
        blur.copyConfigurationFrom(this.blur);
        this.blur = blur;
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        for (TASelector selector : this.selectors) {
            selector.prepareExpression(scope);
        }
        scope.assignTo(this.anchorPoint);
        scope.assignTo(this.position);
        scope.assignTo(this.scale);
        scope.assignTo(this.skew);
        scope.assignTo(this.skewAxis);
        scope.assignTo(this.rotationX);
        scope.assignTo(this.rotationY);
        scope.assignTo(this.rotationZ);
        scope.assignTo(this.opacity);
        scope.assignTo(this.fillRGB);
        scope.assignTo(this.fillHue);
        scope.assignTo(this.fillSaturation);
        scope.assignTo(this.fillLuminosity);
        scope.assignTo(this.fillOpacity);
        scope.assignTo(this.strokeRGB);
        scope.assignTo(this.strokeHue);
        scope.assignTo(this.strokeSaturation);
        scope.assignTo(this.strokeLuminosity);
        scope.assignTo(this.strokeOpacity);
        scope.assignTo(this.strokeWidth);
        scope.assignTo(this.tracking);
        scope.assignTo(this.lineSpacing);
        scope.assignTo(this.characterRange);
        scope.assignTo(this.characterValue);
        scope.assignTo(this.characterOffset);
        scope.assignTo(this.blur);
    }

    @Override
    public Object createExpressionElement(CoreContext context) {
        return new TextAnimatorExpressionElement(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableAnchorPointGrouping
    extends AbstractAnimatableEnum<TextAnimator.AnchorPointGrouping> {
        public AnimatableAnchorPointGrouping(TextAnimator.AnchorPointGrouping staticValue, Collection<Keyframe<TextAnimator.AnchorPointGrouping>> keyframes, String expression) {
            super(TextAnimator.AnchorPointGrouping.class, staticValue, keyframes, expression);
        }

        public AnimatableAnchorPointGrouping(TextAnimator.AnchorPointGrouping defaultValue) {
            super(TextAnimator.AnchorPointGrouping.class, defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableCharacterAlignment
    extends AbstractAnimatableEnum<TextAnimator.CharacterAlignment> {
        public AnimatableCharacterAlignment(TextAnimator.CharacterAlignment staticValue, Collection<Keyframe<TextAnimator.CharacterAlignment>> keyframes, String expression) {
            super(TextAnimator.CharacterAlignment.class, staticValue, keyframes, expression);
        }

        public AnimatableCharacterAlignment(TextAnimator.CharacterAlignment defaultValue) {
            super(TextAnimator.CharacterAlignment.class, defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableCharacterRange
    extends AbstractAnimatableEnum<TextAnimator.CharacterRange> {
        public AnimatableCharacterRange(TextAnimator.CharacterRange staticValue, Collection<Keyframe<TextAnimator.CharacterRange>> keyframes, String expression) {
            super(TextAnimator.CharacterRange.class, staticValue, keyframes, expression);
        }

        public AnimatableCharacterRange(TextAnimator.CharacterRange defaultValue) {
            super(TextAnimator.CharacterRange.class, defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TextAnimatorExpressionElement {
        private final CoreContext context;

        public TextAnimatorExpressionElement(CoreContext context) {
            this.context = context;
        }

        public Object getSelectors() {
            Object[] array = new Object[TextAnimatorImpl.this.selectors.size()];
            int i = 0;
            while (i < array.length) {
                array[i] = this.elem((Expressionee)TextAnimatorImpl.this.selectors.get(i));
                ++i;
            }
            return array;
        }

        public Object selector(int index) {
            return this.elem((Expressionee)TextAnimatorImpl.this.selectors.get(index - 1));
        }

        public Object selector(String name) {
            for (TASelector selector : TextAnimatorImpl.this.selectors) {
                if (!selector.getName().equals(name)) continue;
                return this.elem(selector);
            }
            return null;
        }

        public Object getAnchorPoint() {
            return this.elem(TextAnimatorImpl.this.anchorPoint);
        }

        public Object getPosition() {
            return this.elem(TextAnimatorImpl.this.position);
        }

        public Object getScale() {
            return this.elem(TextAnimatorImpl.this.scale);
        }

        public Object getSkew() {
            return this.elem(TextAnimatorImpl.this.skew);
        }

        public Object getSkewAxis() {
            return this.elem(TextAnimatorImpl.this.skewAxis);
        }

        public Object getRotationX() {
            return this.elem(TextAnimatorImpl.this.rotationX);
        }

        public Object getRotationY() {
            return this.elem(TextAnimatorImpl.this.rotationY);
        }

        public Object getRotationZ() {
            return this.elem(TextAnimatorImpl.this.rotationZ);
        }

        public Object getRotation() {
            return this.getRotationZ();
        }

        public Object getOpacity() {
            return this.elem(TextAnimatorImpl.this.opacity);
        }

        public Object getFillRGB() {
            return this.elem(TextAnimatorImpl.this.fillRGB);
        }

        public Object getFillHue() {
            return this.elem(TextAnimatorImpl.this.fillHue);
        }

        public Object getFillSaturation() {
            return this.elem(TextAnimatorImpl.this.fillSaturation);
        }

        public Object getFillLuminosity() {
            return this.elem(TextAnimatorImpl.this.fillLuminosity);
        }

        public Object getFillOpacity() {
            return this.elem(TextAnimatorImpl.this.fillOpacity);
        }

        public Object getStrokeRGB() {
            return this.elem(TextAnimatorImpl.this.strokeRGB);
        }

        public Object getStrokeHue() {
            return this.elem(TextAnimatorImpl.this.strokeHue);
        }

        public Object getStrokeSaturation() {
            return this.elem(TextAnimatorImpl.this.strokeSaturation);
        }

        public Object getStrokeLuminosity() {
            return this.elem(TextAnimatorImpl.this.strokeLuminosity);
        }

        public Object getStrokeOpacity() {
            return this.elem(TextAnimatorImpl.this.strokeOpacity);
        }

        public Object getStrokeWidth() {
            return this.elem(TextAnimatorImpl.this.strokeWidth);
        }

        public Object getTracking() {
            return this.elem(TextAnimatorImpl.this.tracking);
        }

        public Object getLineSpacing() {
            return this.elem(TextAnimatorImpl.this.lineSpacing);
        }

        public Object getCharacterRange() {
            return this.elem(TextAnimatorImpl.this.characterRange);
        }

        public Object getCharacterValue() {
            return this.elem(TextAnimatorImpl.this.characterValue);
        }

        public Object getCharacterOffset() {
            return this.elem(TextAnimatorImpl.this.characterOffset);
        }

        public Object getBlur() {
            return this.elem(TextAnimatorImpl.this.blur);
        }

        private <T> T elem(Expressionee exprnee) {
            return this.context.getExpressionElement(exprnee);
        }
    }
}

