/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.core.JavieRuntimeException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

public class Java6Update26Detection {
    public static void patch() {
        String platform = SWT.getPlatform();
        if (!platform.equals("win32")) {
            return;
        }
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            return;
        }
        String[] javaVersions = javaVersion.split("[._]", 4);
        if (javaVersions.length != 4) {
            return;
        }
        int[] num = new int[4];
        try {
            int i = 0;
            while (i < 4) {
                num[i] = Integer.parseInt(javaVersions[i]);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        if (num[0] < 1) {
            return;
        }
        if (num[0] <= 1) {
            if (num[1] < 6) {
                return;
            }
            if (num[1] <= 6) {
                if (num[2] < 0) {
                    return;
                }
                if (num[2] <= 0) {
                    if (num[3] < 26) {
                        return;
                    }
                    if (num[3] > 26) {
                        // empty if block
                    }
                }
            }
        }
        try {
            ClassLoader loader = SWT.class.getClassLoader();
            ClassPool pool = new ClassPool();
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass targetClass = pool.get("org.eclipse.swt.widgets.FileDialog");
            targetClass.addField(CtField.make((String)"public static Class alertClass;", (CtClass)targetClass), "null");
            targetClass.addField(CtField.make((String)"private static int failedCount;", (CtClass)targetClass), "0");
            CtMethod openMethod = targetClass.getDeclaredMethod("open");
            openMethod.setName("open_orig");
            String newOpenSrc = "public String open() {\tlong t1 = System.currentTimeMillis();\tString result = open_orig();\tlong t2 = System.currentTimeMillis();\tif (result != null || t2 - t1 > 5000) {\t\tfailedCount = 0x80000000;\t} else if (t2 - t1 < 500 && ++failedCount >=2 && alertClass != null) {\t\talertClass.getMethod(\"alert\", new Class[]{ org.eclipse.swt.widgets.Shell.class })\t\t\t\t.invoke(null, new Object[]{ parent });\t}\treturn result;}";
            targetClass.addMethod(CtMethod.make((String)newOpenSrc, (CtClass)targetClass));
            Class clazz = targetClass.toClass(loader, null);
            clazz.getField("alertClass").set(null, Java6Update26Detection.class);
        }
        catch (Exception e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    public static void alert(Shell parent) {
        MessageDialog.openError((Shell)parent, (String)"Java 6 Update 26 \u306e\u4e0d\u5177\u5408\u3092\u691c\u51fa\u3057\u307e\u3057\u305f", (String)"\u3054\u5229\u7528\u4e2d\u306eOS\u3068Java\u306e\u7d44\u307f\u5408\u308f\u305b\u3067\u306f\u3001Javie\u306f\u6b63\u5e38\u306b\u52d5\u4f5c\u3057\u307e\u305b\u3093\u3002Java 6 Update 25 \u3092\u5229\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
    }
}

