/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.project.AddEffectsOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.layercomp.EffectElement;
import ch.kuramo.javie.app.views.layercomp.EffectsElement;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Util;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchWindow;

public class AddEffectAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchWindow window;
    private final EffectDescriptor descriptor;
    private final Set<Element> elements = Util.newLinkedHashSet();

    public AddEffectAction(IWorkbenchWindow window, Viewer viewer, EffectDescriptor descriptor) {
        super(descriptor.getLabel().replaceAll("&", "&&"));
        this.window = window;
        this.descriptor = descriptor;
        this.updateState(viewer.getSelection());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void updateState(ISelection selection) {
        this.elements.clear();
        if (selection instanceof IStructuredSelection) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (o instanceof LayerElement) {
                    LayerElement element = (LayerElement)o;
                    if (element.layer instanceof EffectableLayer) {
                        this.elements.add(element);
                        continue;
                    }
                } else if (o instanceof EffectsElement || o instanceof EffectElement) {
                    this.elements.add((Element)o);
                    continue;
                }
                this.elements.clear();
                break;
            }
        }
        this.setEnabled(!this.elements.isEmpty());
    }

    public EffectDescriptor getEffectDescriptor() {
        return this.descriptor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateState(event.getSelection());
    }

    public void run() {
        LinkedHashMap effectIndices = Util.newLinkedHashMap();
        for (Element e : this.elements) {
            int index;
            EffectableLayer layer;
            if (e instanceof LayerElement) {
                layer = (EffectableLayer)((LayerElement)e).layer;
                index = layer.getEffects().size();
            } else if (e instanceof EffectsElement) {
                layer = (EffectableLayer)((LayerElement)e.parent).layer;
                index = layer.getEffects().size();
            } else {
                if (!(e instanceof EffectElement)) continue;
                layer = (EffectableLayer)((LayerElement)e.parent.parent).layer;
                index = layer.getEffects().indexOf(((EffectElement)e).effect);
            }
            if (effectIndices.containsKey(layer) && (Integer)effectIndices.get(layer) <= index) continue;
            effectIndices.put(layer, index);
        }
        if (!effectIndices.isEmpty()) {
            ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
            pm.postOperation(new AddEffectsOperation(pm, effectIndices, this.descriptor));
        }
    }
}

