/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.actions.PrecomposeDialog;
import ch.kuramo.javie.app.project.PrecomposeOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Util;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;

public class PrecomposeAction
extends Action {
    private final LayerCompositionView view;
    private final List<Layer> layers = Util.newList();

    public PrecomposeAction(LayerCompositionView view, TreeViewer viewer) {
        super("\u30d7\u30ea\u30b3\u30f3\u30dd\u30fc\u30ba...");
        this.view = view;
        this.updateState(viewer.getSelection());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PrecomposeAction.this.updateState(event.getSelection());
            }
        });
    }

    private void updateState(ISelection selection) {
        List list = Util.newList();
        boolean enabled = false;
        IStructuredSelection ss = (IStructuredSelection)selection;
        for (Object obj : ss.toList()) {
            if (!(obj instanceof LayerElement)) continue;
            Layer layer = ((LayerElement)obj).layer;
            list.add(layer);
            if (!(layer instanceof MediaLayer)) continue;
            enabled = true;
        }
        this.layers.clear();
        this.setEnabled(enabled);
        if (enabled) {
            Collections.reverse(list);
            this.layers.addAll(list);
        }
    }

    public void run() {
        if (!this.layers.isEmpty()) {
            ProjectManager pm = ProjectManager.forWorkbenchWindow(this.view.getSite().getWorkbenchWindow());
            CompositionItem compItem = this.view.getCompositionItem();
            boolean canLeaveAttrs = this.layers.size() == 1 && this.layers.get(0) instanceof MediaItemLayer;
            String newCompName = this.layers.size() == 1 ? String.valueOf(this.layers.get(0).getName()) + " \u30d7\u30ea\u30b3\u30f3\u30dd" : "\u30d7\u30ea\u30b3\u30f3\u30dd";
            PrecomposeDialog dialog = new PrecomposeDialog(this.view.getSite().getShell(), canLeaveAttrs, compItem.getName(), pm.getUnusedItemName(newCompName));
            if (dialog.open() == 0) {
                LayerComposition comp = (LayerComposition)compItem.getComposition();
                pm.postOperation(new PrecomposeOperation(pm, comp, this.layers, dialog.isLeaveAttrs(), dialog.getNewCompositionName()));
            }
        }
    }
}

