/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ResetPropertiesOperation;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.EffectAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerPropertyElement;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchWindow;

public class ResetPropertiesAction
extends Action {
    private final IWorkbenchWindow window;
    private final TreeViewer viewer;

    public ResetPropertiesAction(IWorkbenchWindow window, TreeViewer viewer) {
        super("\u30ea\u30bb\u30c3\u30c8");
        this.window = window;
        this.viewer = viewer;
        this.setEnabled(false);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = false;
                TreeSelection selection = (TreeSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    enabled = true;
                    for (Object element : selection.toList()) {
                        if (element instanceof AnimatableValueElement || element instanceof LayerPropertyElement) continue;
                        enabled = false;
                        break;
                    }
                }
                ResetPropertiesAction.this.setEnabled(enabled);
            }
        });
    }

    public void run() {
        List list = Util.newList();
        TreeSelection selection = (TreeSelection)this.viewer.getSelection();
        for (Object element : selection.toList()) {
            if (element instanceof LayerAnimatableValueElement) {
                LayerAnimatableValueElement layerAVElem = (LayerAnimatableValueElement)element;
                list.add(new Object[]{layerAVElem.getLayer(), -1, layerAVElem.getProperty()});
                continue;
            }
            if (element instanceof EffectAnimatableValueElement) {
                EffectAnimatableValueElement effectAVElem = (EffectAnimatableValueElement)element;
                list.add(new Object[]{effectAVElem.getLayer(), effectAVElem.getEffectIndex(), effectAVElem.getProperty()});
                continue;
            }
            if (element instanceof LayerPropertyElement) {
                LayerPropertyElement layerPropElem = (LayerPropertyElement)element;
                list.add(new Object[]{layerPropElem.getLayer(), -1, layerPropElem.getProperty()});
                continue;
            }
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
        LayerComposition comp = (LayerComposition)this.viewer.getData("LAYER_COMPOSITION");
        pm.postOperation(new ResetPropertiesOperation(pm, comp, (Object[][])list.toArray((T[])new Object[list.size()][])));
    }
}

