/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.TimeStretchLayerOperation;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.TimeCode;
import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TimeStretchLayerAction
extends Action {
    private final TreeViewer viewer;

    public TimeStretchLayerAction(TreeViewer viewer) {
        super("\u6642\u9593\u4f38\u7e2e...");
        this.viewer = viewer;
        this.setEnabled(false);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = false;
                TreeSelection selection = (TreeSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    enabled = true;
                    for (Object element : selection.toList()) {
                        if (element instanceof LayerElement) continue;
                        enabled = false;
                        break;
                    }
                }
                TimeStretchLayerAction.this.setEnabled(enabled);
            }
        });
    }

    public void run() {
        final List layers = Util.newList();
        TreeSelection selection = (TreeSelection)this.viewer.getSelection();
        for (Object element : selection.toList()) {
            if (!(element instanceof LayerElement)) {
                return;
            }
            layers.add(((LayerElement)element).layer);
        }
        if (layers.isEmpty()) {
            return;
        }
        LayerComposition comp = (LayerComposition)this.viewer.getData("LAYER_COMPOSITION");
        Layer firstLayer = (Layer)layers.get(0);
        Time frameDuration = comp.getFrameDuration();
        final double oldRate = firstLayer.getRate();
        Time oldDuration = oldRate > 0.0 ? firstLayer.getOutPoint().subtract(firstLayer.getInPoint()) : firstLayer.getInPoint().subtract(firstLayer.getOutPoint());
        final String oldTimeCode = TimeCode.toTimeCode((Time)oldDuration, (Time)frameDuration);
        final int base = (int)Math.round((double)frameDuration.timeScale / (double)frameDuration.timeValue);
        final boolean drop = oldTimeCode.indexOf(59) != -1;
        Time origDuration = new Time((long)((double)oldDuration.timeValue * oldRate), oldDuration.timeScale);
        final String origTimeCode = TimeCode.toTimeCode((Time)origDuration, (Time)frameDuration);
        Dialog dialog = new Dialog(this.viewer.getTree().getShell(), oldDuration, frameDuration){
            private Text stretchText;
            private Text durationText;
            private Label baseLabel;
            private Button inPointBtn;
            private Button curFrameBtn;
            private Button outPointBtn;
            private ModifyListener stretchListener;
            private ModifyListener durationListener;
            {
                super($anonymous0);
                this.stretchListener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        double newRate;
                        try {
                            newRate = 100.0 / Double.parseDouble(stretchText.getText().trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            newRate = 0.0;
                        }
                        if (newRate == 0.0) {
                            e.display.beep();
                            baseLabel.setText("");
                            this.getButton(0).setEnabled(false);
                            return;
                        }
                        this.getButton(0).setEnabled(true);
                        Time newDuration = new Time((long)((double)time.timeValue * d / newRate), time.timeScale);
                        String newTimeCode = TimeCode.toTimeCode((Time)newDuration, (Time)time2);
                        durationText.removeModifyListener(durationListener);
                        durationText.setText(newTimeCode);
                        durationText.addModifyListener(durationListener);
                        baseLabel.setText(this.formatBase(newTimeCode, n, bl));
                    }
                };
                this.durationListener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        long frames;
                        String newTimeCode = durationText.getText().trim();
                        long l = frames = newTimeCode.length() > 0 ? TimeCode.parseTimeCode((String)newTimeCode, (Time)time2, (boolean)bl) : 0L;
                        if (frames == 0L) {
                            e.display.beep();
                            baseLabel.setText("");
                            this.getButton(0).setEnabled(false);
                            return;
                        }
                        this.getButton(0).setEnabled(true);
                        Time newDuration = Time.fromFrameNumber((long)frames, (Time)time2);
                        double newRate = (double)time.timeValue * d / (double)newDuration.timeValue;
                        stretchText.removeModifyListener(stretchListener);
                        stretchText.setText(this.formatStretch(100.0 / newRate));
                        stretchText.addModifyListener(stretchListener);
                        newTimeCode = TimeCode.toTimeCode((Time)newDuration, (Time)time2);
                        baseLabel.setText(this.formatBase(newTimeCode, n, bl));
                    }
                };
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("\u6642\u9593\u4f38\u7e2e");
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                RowLayout layout = new RowLayout(512);
                layout.fill = true;
                layout.marginWidth = 5;
                layout.marginHeight = 5;
                composite.setLayout((Layout)layout);
                this.createGroup1(composite);
                this.createGroup2(composite);
                parent.pack();
                return composite;
            }

            private void createGroup1(Composite parent) {
                Group group1 = new Group(parent, 0);
                group1.setText("\u4f38\u7e2e");
                FillLayout layout1 = new FillLayout();
                layout1.marginWidth = 5;
                layout1.marginHeight = 5;
                group1.setLayout((Layout)layout1);
                GridBuilder gb1 = new GridBuilder((Composite)group1, 3, false);
                gb1.hSpan(1).hAlign(131072).label(0, "\u5143\u306e\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3:");
                gb1.hSpan(1).hAlign(4).label(0, String.valueOf(origTimeCode) + "      ");
                gb1.hSpan(1).size(10, 10).composite(0);
                gb1.hSpan(1).hAlign(131072).label(0, "\u4f38\u7e2e\u6bd4\u7387:");
                this.stretchText = gb1.hSpan(1).hAlign(4).text(2048, this.formatStretch(100.0 / oldRate));
                gb1.hSpan(1).hAlign(16384).label(0, "%");
                gb1.hSpan(1).hAlign(131072).label(0, "\u65b0\u898f\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3:");
                this.durationText = gb1.hSpan(1).hAlign(4).text(2048, oldTimeCode);
                this.baseLabel = gb1.hSpan(1).hAlign(16384).label(0, this.formatBase(oldTimeCode, base, drop));
                this.stretchText.addModifyListener(this.stretchListener);
                this.durationText.addModifyListener(this.durationListener);
            }

            private void createGroup2(Composite parent) {
                Group group2 = new Group(parent, 0);
                group2.setText("\u57fa\u6e96\u306b\u3059\u308b\u5730\u70b9");
                RowLayout layout2 = new RowLayout(512);
                layout2.marginWidth = 7;
                layout2.marginHeight = 7;
                group2.setLayout((Layout)layout2);
                this.inPointBtn = new Button((Composite)group2, 16);
                this.curFrameBtn = new Button((Composite)group2, 16);
                this.outPointBtn = new Button((Composite)group2, 16);
                this.inPointBtn.setText("\u30ec\u30a4\u30e4\u30fc\u30a4\u30f3\u30dd\u30a4\u30f3\u30c8");
                this.curFrameBtn.setText("\u73fe\u5728\u306e\u30d5\u30ec\u30fc\u30e0");
                this.outPointBtn.setText("\u30ec\u30a4\u30e4\u30fc\u30a2\u30a6\u30c8\u30dd\u30a4\u30f3\u30c8");
                this.inPointBtn.setSelection(true);
            }

            private String formatStretch(double stretch) {
                String s = String.format("%.4f", stretch);
                int dotIndex = s.indexOf(46);
                if (dotIndex != -1) {
                    int i = s.length() - 1;
                    while (i >= dotIndex) {
                        char c = s.charAt(i);
                        if (c != '0') {
                            return s.substring(0, c == '.' ? i : i + 1);
                        }
                        --i;
                    }
                }
                return s;
            }

            private String formatBase(String timeCode, int base2, boolean drop2) {
                return String.format("= %s (\u30d9\u30fc\u30b9 %d%s)  ", timeCode, base2, drop2 ? "\u30c9\u30ed\u30c3\u30d7" : "");
            }

            protected void okPressed() {
                double newRate = 100.0 / Double.parseDouble(this.stretchText.getText().trim());
                boolean inPoint = this.inPointBtn.getSelection();
                boolean curFrame = this.curFrameBtn.getSelection();
                super.okPressed();
                ProjectManager pm = (ProjectManager)TimeStretchLayerAction.this.viewer.getData("PROJECT_MANAGER");
                if (curFrame) {
                    TimelineManager tlm = (TimelineManager)TimeStretchLayerAction.this.viewer.getData("TIMELINE_MANAGER");
                    pm.postOperation(new TimeStretchLayerOperation(pm, (List<Layer>)layers, newRate, tlm.getCurrentTime()));
                } else {
                    pm.postOperation(new TimeStretchLayerOperation(pm, (List<Layer>)layers, newRate, inPoint));
                }
            }
        };
        dialog.open();
    }
}

