/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyLayerAnimatableValueOperation<V>
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _property;
    private final V _oldValue;
    private volatile V _newValue;

    public ModifyLayerAnimatableValueOperation(ProjectManager projectManager, Layer layer, String property, V value, String relation, String name) {
        super(projectManager, String.valueOf(name) + "\u306e\u5909\u66f4", relation);
        LayerComposition comp = projectManager.checkLayer(layer);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._property = property;
        this._oldValue = avalue.getStaticValue();
        this._newValue = value;
        this._noEffect = this._newValue != null && this._newValue.equals(this._oldValue) || this._newValue == null && this._oldValue == null;
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyProperty(this._newValue, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyProperty(this._oldValue, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyProperty(V value, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, this._property);
        if (avalue.hasKeyframe()) {
            throw new IllegalStateException("property has keyframe");
        }
        avalue.clearKeyframes(value);
        if (pm != null) {
            pm.fireLayerPropertyChange(layer, this._property);
        }
    }

    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            this.modifyProperty(this._newValue, project, null);
            return true;
        }
        if (!(operation instanceof ModifyLayerAnimatableValueOperation)) {
            return false;
        }
        ModifyLayerAnimatableValueOperation newOp = (ModifyLayerAnimatableValueOperation)operation;
        if (!(newOp._compId.equals(this._compId) && newOp._layerId.equals(this._layerId) && newOp._property.equals(this._property))) {
            return false;
        }
        V newValue = newOp._newValue;
        if (this._newValue != null && !this._newValue.equals(newValue) || this._newValue == null && newValue != null) {
            this._newValue = newValue;
            this.modifyProperty(this._newValue, project, pm);
            this._noEffect = this._newValue != null && this._newValue.equals(this._oldValue) || this._newValue == null && this._oldValue == null;
        }
        return true;
    }
}

