/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyLayerCompSettingsOperation
extends ProjectOperation {
    private final String _compItemId;
    private final Map<String, Object[]> _values = Util.newMap();

    public ModifyLayerCompSettingsOperation(ProjectManager pm, CompositionItem compItem, String name, ColorMode colorMode, Size2i size, Time frameDuration, Time duration, boolean frameDurationPreserved, double motionBlurShutterAngle, double motionBlurShutterPhase, int motionBlurSamples) {
        super(pm, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u8a2d\u5b9a\u306e\u5909\u66f4", true);
        pm.checkItem((Item)compItem);
        this._compItemId = compItem.getId();
        LayerComposition comp = (LayerComposition)compItem.getComposition();
        this._noEffect = true;
        this.putValues("name", compItem.getName(), name);
        this.putValues("colorMode", comp.getColorMode(), colorMode);
        this.putValues("size", comp.getSize(), size);
        this.putValues("frameDuration", comp.getFrameDuration(), frameDuration);
        this.putValues("duration", comp.getDuration(), duration);
        this.putValues("frameDurationPreserved", comp.isFrameDurationPreserved(), frameDurationPreserved);
        this.putValues("motionBlurShutterAngle", comp.getMotionBlurShutterAngle(), motionBlurShutterAngle);
        this.putValues("motionBlurShutterPhase", comp.getMotionBlurShutterPhase(), motionBlurShutterPhase);
        this.putValues("motionBlurSamples", comp.getMotionBlurSamples(), motionBlurSamples);
    }

    private <T> void putValues(String name, T oldValue, T newValue) {
        this._values.put(name, new Object[]{oldValue, newValue});
        this._noEffect &= oldValue.equals(newValue);
    }

    private <T> T getValue(String name, boolean undo) {
        Object value = this._values.get(name)[undo ? 0 : 1];
        return (T)value;
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifySettings(project, pm, false);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifySettings(project, pm, true);
        return Status.OK_STATUS;
    }

    private void modifySettings(Project project, ProjectManager pm, boolean undo) {
        CompositionItem compItem = (CompositionItem)project.getItem(this._compItemId);
        LayerComposition comp = (LayerComposition)compItem.getComposition();
        compItem.setName((String)this.getValue("name", undo));
        comp.setColorMode((ColorMode)this.getValue("colorMode", undo));
        comp.setSize((Size2i)this.getValue("size", undo));
        comp.setFrameDuration((Time)this.getValue("frameDuration", undo));
        comp.setDuration((Time)this.getValue("duration", undo));
        comp.setFrameDurationPreserved(((Boolean)this.getValue("frameDurationPreserved", undo)).booleanValue());
        comp.setMotionBlurShutterAngle(((Double)this.getValue("motionBlurShutterAngle", undo)).doubleValue());
        comp.setMotionBlurShutterPhase(((Double)this.getValue("motionBlurShutterPhase", undo)).doubleValue());
        comp.setMotionBlurSamples(((Integer)this.getValue("motionBlurSamples", undo)).intValue());
        if (pm != null) {
            pm.fireItemNameChange((Item)compItem);
            pm.fireCompositionSettingsChange((Composition)comp);
        }
    }

    public String getCompositionItemId() {
        return this._compItemId;
    }
}

