/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TAProperty;
import ch.kuramo.javie.core.TARangeSelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NewTextAnimatorOperation
extends ProjectOperation {
    private final String compId;
    private final String layerId;
    private final String data;
    @Inject
    private ProjectElementFactory elementFactory;
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;

    public NewTextAnimatorOperation(ProjectManager pm, TextLayer layer, TAProperty ... properties) {
        super(pm, "\u30c6\u30ad\u30b9\u30c8\u30a2\u30cb\u30e1\u30fc\u30bf\u306e\u8ffd\u52a0");
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = pm.checkLayer((Layer)layer);
        this.compId = comp.getId();
        this.layerId = layer.getId();
        TextAnimator animator = this.elementFactory.newTextAnimator();
        animator.setName(this.uniqueAnimatorNames(layer, animator.getName()));
        TARangeSelector selector = this.elementFactory.newTARangeSelector();
        selector.setName(String.valueOf(selector.getName()) + " 1");
        animator.getSelectors().add(selector);
        animator.getProperties().addAll(Arrays.asList(properties));
        this.data = this.encoder.encodeElement((Object)animator);
    }

    private String uniqueAnimatorNames(TextLayer layer, String prefix) {
        String name;
        Set names = Util.newSet();
        for (TextAnimator animator : layer.getTextAnimators()) {
            names.add(animator.getName());
        }
        int n = 1;
        while (names.contains(name = String.valueOf(prefix) + " " + n++)) {
        }
        return name;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        TextAnimator ta;
        try {
            ta = (TextAnimator)this.decoder.decodeElement((CharSequence)this.data, TextAnimator.class);
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding TextAnimator data", (Throwable)e);
        }
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        TextLayer layer = (TextLayer)comp.getLayer(this.layerId);
        List list = layer.getTextAnimators();
        int index = list.size();
        list.add(ta);
        if (pm != null) {
            this.fireTextAnimatorsAddRemove(true, comp, layer, index, pm);
        }
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        TextLayer layer = (TextLayer)comp.getLayer(this.layerId);
        List list = layer.getTextAnimators();
        int index = list.size() - 1;
        list.remove(index);
        if (pm != null) {
            this.fireTextAnimatorsAddRemove(false, comp, layer, index, pm);
        }
        return Status.OK_STATUS;
    }

    private Object[][] createData(LayerComposition comp, TextLayer layer, int animatorIndex, boolean add) {
        List data = Util.newList();
        if (add) {
            data.add(new Object[]{layer, animatorIndex, "new"});
        } else {
            data.add(new Object[]{layer, animatorIndex});
        }
        return (Object[][])data.toArray((T[])new Object[data.size()][]);
    }

    private void fireTextAnimatorsAddRemove(boolean add, LayerComposition comp, TextLayer layer, int animatorIndex, ProjectManager pm) {
        Object[][] data = this.createData(comp, layer, animatorIndex, add);
        if (add) {
            pm.fireTextAnimatorsAdd(comp, data);
        } else {
            pm.fireTextAnimatorsRemove(comp, data);
        }
    }
}

