/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.app.project.ProjectOperationCollection;
import ch.kuramo.javie.app.project.ThreeDSwitchOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.TransformableLayer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PerCharacter3DOperation
extends ProjectOperation {
    private final String compId;
    private final String layerId;
    private final boolean perCharacter3D;

    public static ProjectOperation toggle(ProjectManager pm, TextLayer layer) {
        boolean threeD = LayerNature.isThreeD((Layer)layer);
        boolean perCharacter3D = layer.isPerCharacter3D();
        if (!threeD && perCharacter3D) {
            throw new IllegalStateException();
        }
        PerCharacter3DOperation opPerChar3d = new PerCharacter3DOperation(pm, layer, !perCharacter3D);
        if (perCharacter3D || threeD) {
            return opPerChar3d;
        }
        ThreeDSwitchOperation op3dSwitch = new ThreeDSwitchOperation(pm, (TransformableLayer)layer);
        op3dSwitch.setSyncShadow(true);
        opPerChar3d.setSyncShadow(true);
        ProjectOperationCollection op = new ProjectOperationCollection(pm, opPerChar3d.getLabel());
        op.add(op3dSwitch);
        op.add(opPerChar3d);
        return op;
    }

    public static ProjectOperation disable3D(ProjectManager pm, TextLayer layer) {
        if (!LayerNature.isThreeD((Layer)layer)) {
            throw new IllegalStateException();
        }
        ThreeDSwitchOperation op3dSwitch = new ThreeDSwitchOperation(pm, (TransformableLayer)layer);
        if (!layer.isPerCharacter3D()) {
            return op3dSwitch;
        }
        PerCharacter3DOperation opPerChar3d = new PerCharacter3DOperation(pm, layer, false);
        opPerChar3d.setSyncShadow(true);
        op3dSwitch.setSyncShadow(true);
        ProjectOperationCollection op = new ProjectOperationCollection(pm, op3dSwitch.getLabel());
        op.add(opPerChar3d);
        op.add(op3dSwitch);
        return op;
    }

    private PerCharacter3DOperation(ProjectManager pm, TextLayer layer, boolean perCharacter3D) {
        super(pm, "\u6587\u5b57\u5358\u4f4d\u306e3D\u5316");
        LayerComposition comp = pm.checkLayer((Layer)layer);
        this.compId = comp.getId();
        this.layerId = layer.getId();
        this.perCharacter3D = perCharacter3D;
        this._noEffect = layer.isPerCharacter3D() == perCharacter3D;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setPerCharacter3D(project, pm, this.perCharacter3D);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setPerCharacter3D(project, pm, !this.perCharacter3D);
        return Status.OK_STATUS;
    }

    private void setPerCharacter3D(Project project, ProjectManager pm, boolean perCharacter3D) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        TextLayer layer = (TextLayer)comp.getLayer(this.layerId);
        if (perCharacter3D && !LayerNature.isThreeD((Layer)layer)) {
            throw new ExecutionException("the layer is not 3D");
        }
        layer.setPerCharacter3D(perCharacter3D);
        if (pm != null) {
            pm.fireLayerPropertyChange((Layer)layer, "perCharacter3D");
        }
    }
}

