/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectEvent
extends EventObject {
    private static final long serialVersionUID = 4412699553814727247L;
    public final Type type;
    public final Object data;
    public final Composition composition;
    public final Layer layer;
    public final int effectIndex;
    public final String property;

    protected ProjectEvent(ProjectManager pm, Type type, Object data, Composition comp, Layer layer, int effectIndex, String property) {
        super(pm);
        this.type = type;
        this.data = data;
        this.composition = comp;
        this.layer = layer;
        this.effectIndex = effectIndex;
        this.property = property;
    }

    public ProjectManager getProjectManager() {
        return (ProjectManager)this.source;
    }

    @Override
    public String toString() {
        return String.format("ProjectEvent {type=%s data=%s projectManager=%s composition=%s layer=%s}", new Object[]{this.type, this.data, this.getProjectManager(), this.composition, this.layer});
    }

    public static ProjectEvent createProjectInitializeEvent(ProjectManager pm) {
        return new ProjectEvent(pm, Type.PROJECT_INITIALIZE, null, null, null, -1, null);
    }

    public static ProjectEvent createProjectDisposeEvent(ProjectManager pm) {
        return new ProjectEvent(pm, Type.PROJECT_DISPOSE, null, null, null, -1, null);
    }

    public static ProjectEvent createDirtyChangeEvent(ProjectManager pm) {
        return new ProjectEvent(pm, Type.DIRTY_CHANGE, null, null, null, -1, null);
    }

    public static ProjectEvent createFileChangeEvent(ProjectManager pm) {
        return new ProjectEvent(pm, Type.FILE_CHANGE, null, null, null, -1, null);
    }

    public static ProjectEvent createItemNameChangeEvent(ProjectManager pm, Item item) {
        pm.checkItem(item);
        return new ProjectEvent(pm, Type.ITEM_NAME_CHANGE, item, null, null, -1, null);
    }

    public static ProjectEvent createItemUpdateEvent(ProjectManager pm, Item item) {
        pm.checkItem(item);
        return new ProjectEvent(pm, Type.ITEM_UPDATE, item, null, null, -1, null);
    }

    private static <T> Set<T> toUnmodifiableSet(Collection<? extends T> c) {
        if (c == null) {
            return Collections.emptySet();
        }
        if (c instanceof Set) {
            Set set = (Set)c;
            return Collections.unmodifiableSet(set);
        }
        return Collections.unmodifiableSet(new LinkedHashSet<T>(c));
    }

    private static void checkItems(ProjectManager pm, Collection<? extends Item> items) {
        if (items != null) {
            for (Item item : items) {
                pm.checkItem(item);
            }
        }
    }

    public static ProjectEvent createItemsAddEvent(ProjectManager pm, Collection<? extends Item> items, Collection<? extends Item> relatedItems) {
        ProjectEvent.checkItems(pm, items);
        ProjectEvent.checkItems(pm, relatedItems);
        Set[] data = new Set[]{ProjectEvent.toUnmodifiableSet(items), ProjectEvent.toUnmodifiableSet(relatedItems)};
        return new ProjectEvent(pm, Type.ITEMS_ADD, data, null, null, -1, null);
    }

    public static ProjectEvent createItemsRemoveEvent(ProjectManager pm, Collection<? extends Item> items, Collection<? extends Item> relatedItems) {
        ProjectEvent.checkItems(pm, relatedItems);
        Set[] data = new Set[]{ProjectEvent.toUnmodifiableSet(items), ProjectEvent.toUnmodifiableSet(relatedItems)};
        return new ProjectEvent(pm, Type.ITEMS_REMOVE, data, null, null, -1, null);
    }

    public static ProjectEvent createItemsReparentEvent(ProjectManager pm, Collection<? extends Item> items, Collection<? extends Item> relatedItems) {
        ProjectEvent.checkItems(pm, items);
        ProjectEvent.checkItems(pm, relatedItems);
        Set[] data = new Set[]{ProjectEvent.toUnmodifiableSet(items), ProjectEvent.toUnmodifiableSet(relatedItems)};
        return new ProjectEvent(pm, Type.ITEMS_REPARENT, data, null, null, -1, null);
    }

    public static ProjectEvent createCompositionSettingsChangeEvent(ProjectManager pm, Composition comp) {
        pm.checkComposition(comp);
        return new ProjectEvent(pm, Type.COMPOSITION_SETTINGS_CHANGE, null, comp, null, -1, null);
    }

    public static ProjectEvent createCompositionPropertyChangeEvent(ProjectManager pm, Composition comp, String property) {
        pm.checkComposition(comp);
        return new ProjectEvent(pm, Type.COMPOSITION_PROPERTY_CHANGE, null, comp, null, -1, property);
    }

    public static ProjectEvent createLayerPropertyChangeEvent(ProjectManager pm, Layer layer, String property) {
        return new ProjectEvent(pm, Type.LAYER_PROPERTY_CHANGE, null, (Composition)pm.checkLayer(layer), layer, -1, property);
    }

    public static ProjectEvent createLayerItemChangeEvent(ProjectManager pm, ItemLayer<?> layer) {
        return new ProjectEvent(pm, Type.LAYER_ITEM_CHANGE, null, (Composition)pm.checkLayer((Layer)layer), (Layer)layer, -1, null);
    }

    private static void checkLayers(ProjectManager pm, LayerComposition comp, Collection<? extends Layer> layers) {
        for (Layer layer : layers) {
            if (pm.checkLayer(layer) == comp) continue;
            throw new IllegalArgumentException("a layer does not belong to the composition");
        }
    }

    public static ProjectEvent createLayersAddEvent(ProjectManager pm, LayerComposition comp, Collection<? extends Layer> layers) {
        pm.checkComposition((Composition)comp);
        ProjectEvent.checkLayers(pm, comp, layers);
        return new ProjectEvent(pm, Type.LAYERS_ADD, ProjectEvent.toUnmodifiableSet(layers), (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createLayersRemoveEvent(ProjectManager pm, LayerComposition comp, Collection<? extends Layer> layers) {
        pm.checkComposition((Composition)comp);
        return new ProjectEvent(pm, Type.LAYERS_REMOVE, ProjectEvent.toUnmodifiableSet(layers), (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createLayersReorderEvent(ProjectManager pm, LayerComposition comp, Collection<? extends Layer> layers) {
        pm.checkComposition((Composition)comp);
        ProjectEvent.checkLayers(pm, comp, layers);
        return new ProjectEvent(pm, Type.LAYERS_REORDER, ProjectEvent.toUnmodifiableSet(layers), (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createTextAnimatorsAddEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.TEXT_ANIMATORS_ADD, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createTextAnimatorsRemoveEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.TEXT_ANIMATORS_REMOVE, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createTASelectorsAddEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.TA_SELECTORS_ADD, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createTASelectorsRemoveEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.TA_SELECTORS_REMOVE, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createTAPropertiesAddEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.TA_PROPERTIES_ADD, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createTAPropertiesRemoveEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.TA_PROPERTIES_REMOVE, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createEffectPropertyChangeEvent(ProjectManager pm, EffectableLayer layer, int effectIndex, String property) {
        return new ProjectEvent(pm, Type.EFFECT_PROPERTY_CHANGE, null, (Composition)pm.checkLayer((Layer)layer), (Layer)layer, effectIndex, property);
    }

    public static ProjectEvent createEffectsAddEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.EFFECTS_ADD, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createEffectsRemoveEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.EFFECTS_REMOVE, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createLayerExpressionChangeEvent(ProjectManager pm, Layer layer, String property) {
        return new ProjectEvent(pm, Type.LAYER_EXPRESSION_CHANGE, null, (Composition)pm.checkLayer(layer), layer, -1, property);
    }

    public static ProjectEvent createEffectExpressionChangeEvent(ProjectManager pm, EffectableLayer layer, int effectIndex, String property) {
        return new ProjectEvent(pm, Type.EFFECT_EXPRESSION_CHANGE, null, (Composition)pm.checkLayer((Layer)layer), (Layer)layer, effectIndex, property);
    }

    public static ProjectEvent createExpressionsAddEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.EXPRESSIONS_ADD, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createExpressionsRemoveEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.EXPRESSIONS_REMOVE, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createLayerTimesChangeEvent(ProjectManager pm, LayerComposition comp, Collection<? extends Layer> layers) {
        return new ProjectEvent(pm, Type.LAYER_TIMES_CHANGE, ProjectEvent.toUnmodifiableSet(layers), (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createKeyframesChangeEvent(ProjectManager pm, LayerComposition comp, Object[][] data) {
        return new ProjectEvent(pm, Type.KEYFRAMES_CHANGE, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createLayerSlipEditEvent(ProjectManager pm, LayerComposition comp, Object[] data) {
        return new ProjectEvent(pm, Type.LAYER_SLIP_EDIT, data, (Composition)comp, null, -1, null);
    }

    public static ProjectEvent createShadowOperationExecutionEvent(ProjectManager pm) {
        return new ProjectEvent(pm, Type.SHADOW_OPERATION_EXECUTION, null, null, null, -1, null);
    }

    public static Item getItem(ProjectEvent event) {
        switch (event.type) {
            case ITEM_NAME_CHANGE: 
            case ITEM_UPDATE: {
                return (Item)event.data;
            }
        }
        throw new IllegalArgumentException("event type is neither ITEM_NAME_CHANGE nor ITEM_UPDATE: type=" + (Object)((Object)event.type));
    }

    private static Set<Item> getItems(ProjectEvent event, int index) {
        switch (event.type) {
            case ITEMS_ADD: 
            case ITEMS_REMOVE: 
            case ITEMS_REPARENT: {
                break;
            }
            default: {
                throw new IllegalArgumentException("event type is not ITEMS_ADD, ITEMS_REMOVE nor ITEMS_REPARENT: type=" + (Object)((Object)event.type));
            }
        }
        Set set = ((Set[])event.data)[index];
        return set;
    }

    public static Set<Item> getItems(ProjectEvent event) {
        return ProjectEvent.getItems(event, 0);
    }

    public static Set<Item> getRelatedItems(ProjectEvent event) {
        return ProjectEvent.getItems(event, 1);
    }

    public static boolean propertyIsAnimatable(ProjectEvent event) {
        switch (event.type) {
            case LAYER_PROPERTY_CHANGE: {
                return PropertyUtil.getProperty(event.layer, event.property) instanceof AnimatableValue;
            }
            case EFFECT_PROPERTY_CHANGE: {
                EffectableLayer layer = (EffectableLayer)event.layer;
                Effect effect = (Effect)layer.getEffects().get(event.effectIndex);
                return PropertyUtil.getProperty(effect, event.property) instanceof AnimatableValue;
            }
        }
        throw new IllegalArgumentException("event type is not LAYER_PROPERTY_CHANGE nor EFFECT_PROPERTY_CHANGE: type=" + (Object)((Object)event.type));
    }

    public static Set<Layer> getLayers(ProjectEvent event) {
        switch (event.type) {
            case LAYERS_ADD: 
            case LAYERS_REMOVE: 
            case LAYERS_REORDER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("event type is not LAYERS_ADD, LAYERS_REMOVE nor LAYERS_REORDER: type=" + (Object)((Object)event.type));
            }
        }
        Set set = (Set)event.data;
        return set;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PROJECT_INITIALIZE,
        PROJECT_DISPOSE,
        DIRTY_CHANGE,
        FILE_CHANGE,
        ITEM_NAME_CHANGE,
        ITEM_UPDATE,
        ITEMS_ADD,
        ITEMS_REMOVE,
        ITEMS_REPARENT,
        COMPOSITION_SETTINGS_CHANGE,
        COMPOSITION_PROPERTY_CHANGE,
        LAYER_PROPERTY_CHANGE,
        LAYER_ITEM_CHANGE,
        LAYERS_ADD,
        LAYERS_REMOVE,
        LAYERS_REORDER,
        TEXT_ANIMATORS_ADD,
        TEXT_ANIMATORS_REMOVE,
        TA_SELECTORS_ADD,
        TA_SELECTORS_REMOVE,
        TA_PROPERTIES_ADD,
        TA_PROPERTIES_REMOVE,
        EFFECT_PROPERTY_CHANGE,
        EFFECTS_ADD,
        EFFECTS_REMOVE,
        LAYER_EXPRESSION_CHANGE,
        EFFECT_EXPRESSION_CHANGE,
        EXPRESSIONS_ADD,
        EXPRESSIONS_REMOVE,
        LAYER_TIMES_CHANGE,
        KEYFRAMES_CHANGE,
        LAYER_SLIP_EDIT,
        SHADOW_OPERATION_EXECUTION;

    }
}

