/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoveItemsOperation2
extends ProjectOperation {
    private final List<Object[]> itemIndexAndData = Util.newList();
    private List<Object[]> compIndexAndData;
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;

    RemoveItemsOperation2(ProjectManager pm, Collection<Item> items) {
        super(pm, "\u30a2\u30a4\u30c6\u30e0\u306e\u524a\u9664");
        InjectorHolder.getInjector().injectMembers((Object)this);
        List tmp = Util.newList((Collection)pm.getProject().getItems());
        for (Item item : items) {
            int i = tmp.indexOf(item);
            if (i == -1) {
                throw new IllegalArgumentException("item not found");
            }
            this.itemIndexAndData.add(new Object[]{i, this.encoder.encodeElement((Object)item)});
            tmp.remove(i);
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        boolean encodeComp = false;
        if (this.compIndexAndData == null) {
            this.compIndexAndData = Util.newList();
            encodeComp = true;
        }
        List items = Util.newList();
        for (Object[] o : this.itemIndexAndData) {
            Item item = (Item)project.getItems().get((Integer)o[0]);
            if (item instanceof CompositionItem && encodeComp) {
                Composition comp = ((CompositionItem)item).getComposition();
                int compIndex = project.getCompositions().indexOf(comp);
                this.compIndexAndData.add(new Object[]{compIndex, this.encoder.encodeElement((Object)comp)});
            }
            project.getItems().remove(item);
            items.add(item);
        }
        for (Object[] o : this.compIndexAndData) {
            int compIndex = (Integer)o[0];
            project.getCompositions().remove(compIndex);
        }
        if (pm != null) {
            this.fireItemsRemove(items, project, pm);
        }
        this.disposeAll(items);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        List comps = Util.newList();
        ListIterator<Object[]> it = this.compIndexAndData.listIterator(this.compIndexAndData.size());
        while (it.hasPrevious()) {
            Composition comp;
            Object[] o = it.previous();
            try {
                comp = (Composition)this.decoder.decodeElement((CharSequence)((String)o[1]), Composition.class);
                comps.add(comp);
                comp.afterDecode(project);
            }
            catch (ProjectDecodeException e) {
                project.getCompositions().removeAll(comps);
                throw new ExecutionException("error decoding Composition data", (Throwable)e);
            }
            project.getCompositions().add((Integer)o[0], comp);
        }
        List items = Util.newList();
        ListIterator<Object[]> it2 = this.itemIndexAndData.listIterator(this.itemIndexAndData.size());
        while (it2.hasPrevious()) {
            Item item;
            Object[] o = it2.previous();
            try {
                item = (Item)this.decoder.decodeElement((CharSequence)((String)o[1]), Item.class);
                items.add(item);
                item.afterDecode(project);
            }
            catch (ProjectDecodeException e) {
                project.getItems().removeAll(items);
                project.getCompositions().removeAll(comps);
                this.disposeAll(items);
                throw new ExecutionException("error decoding Item data", (Throwable)e);
            }
            project.getItems().add((Integer)o[0], item);
        }
        if (pm != null) {
            this.fireItemsAdd(items, project, pm);
        }
        return Status.OK_STATUS;
    }

    private void fireItemsAdd(Collection<Item> items, Project project, ProjectManager pm) {
        Set parents = Util.newSet();
        for (Item item : items) {
            Folder parent = item.getParent();
            if (parent != null) {
                parents.add(parent);
                continue;
            }
            parents.clear();
            break;
        }
        if (parents.isEmpty()) {
            pm.fireItemsAdd(items, null);
        } else {
            pm.fireItemsAdd(items, parents);
        }
    }

    private void fireItemsRemove(Collection<Item> items, Project project, ProjectManager pm) {
        Set parents = Util.newSet();
        for (Item item : items) {
            Folder parent = item.getParent();
            if (parent != null) {
                parents.add(parent);
                continue;
            }
            parents.clear();
            break;
        }
        parents.retainAll(project.getItems());
        if (parents.isEmpty()) {
            pm.fireItemsRemove(items, null);
        } else {
            pm.fireItemsRemove(items, parents);
        }
    }

    private void disposeAll(Collection<Item> items) {
        for (Item item : items) {
            item.dispose();
        }
    }
}

