/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.core.FileItem;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.ImageSequenceItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.TimeCode;
import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ItemLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ImageUtil.getItemIcon((Item)element);
            }
            case 1: {
                return null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Item item = (Item)element;
        switch (columnIndex) {
            case 0: {
                return item.getName();
            }
            case 2: {
                return this.getKind(item);
            }
            case 3: {
                return this.getSize(item);
            }
            case 4: {
                return this.getDuration(item);
            }
            case 5: {
                return this.getFilePath(item);
            }
        }
        return null;
    }

    private String getKind(Item item) {
        String kind = item.getKind();
        if (kind != null) {
            return kind;
        }
        if (!(item instanceof FileItem)) {
            return null;
        }
        File file = ((FileItem)item).getFile();
        if (file.exists()) {
            return FileSystemView.getFileSystemView().getSystemTypeDescription(file);
        }
        return null;
    }

    private String getSize(Item item) {
        if (!(item instanceof FileItem)) {
            return null;
        }
        File file = ((FileItem)item).getFile();
        if (!file.isFile()) {
            return null;
        }
        double length = file.length();
        String[] suffixes = new String[]{"B", "KB", "MB", "GB"};
        int i = 0;
        while (i < suffixes.length && length >= 1024.0) {
            length /= 1024.0;
            ++i;
        }
        String str = String.format("%.1f", Math.floor(length * 10.0) / 10.0);
        return String.valueOf(str.endsWith(".0") ? str.substring(0, str.length() - 2) : str) + (i < suffixes.length ? suffixes[i] : "TB");
    }

    private String getDuration(Item item) {
        if (!(item instanceof MediaItem)) {
            return null;
        }
        MediaInput input = ((MediaItem)item).getMediaInput();
        Time duration = input.getDuration();
        if (duration == null) {
            return null;
        }
        if (input.isVideoAvailable()) {
            Time frameDuration = input.getVideoFrameDuration();
            if (frameDuration.timeValue > 0L) {
                return TimeCode.toTimeCode((Time)duration, (Time)frameDuration);
            }
            return TimeCode.toTimeCode((Time)duration, (Time)FrameDuration.FPS_59_94);
        }
        double s0 = duration.toSecond();
        int h = (int)s0 / 3600;
        int m = (int)(s0 -= (double)(h * 3600)) / 60;
        int s = (int)(s0 -= (double)(m * 60));
        int ss = (int)((s0 - (double)s) * 100.0);
        return String.format("%d:%02d:%02d.%02d", h, m, s, ss);
    }

    private String getFilePath(Item item) {
        File file;
        if (item instanceof ImageSequenceItem) {
            file = ((ImageSequenceItem)item).getFile().getParentFile();
        } else if (item instanceof FileItem) {
            file = ((FileItem)item).getFile();
        } else {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }
}

