/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;

public class Element {
    public static final Element[] EMPTY_CHILDREN = new Element[0];
    public final TreeViewer viewer;
    public final Element parent;
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");

    private Element(TreeViewer viewer, Element parent) {
        this.viewer = viewer;
        this.parent = parent;
    }

    public Element(TreeViewer viewer) {
        this(viewer, null);
    }

    public Element(Element parent) {
        this(parent.viewer, parent);
    }

    public Image getColumnImage(int columnIndex) {
        return null;
    }

    public String getColumnText(int columnIndex) {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public Element[] getChildren() {
        return EMPTY_CHILDREN;
    }

    public void paintColumn(Event event) {
        if (event.index == 7) {
            TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
            tm.drawCurrentFrameRegion(event);
        }
    }

    public void updateCursor(MouseEvent event, int columnIndex) {
        this.viewer.getTree().setCursor(null);
    }

    public void mouseDown(MouseEvent event, int columnIndex) {
        if (columnIndex == 7) {
            TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
            tm.mouseDown(event);
        }
    }

    public boolean canEdit(int columnIndex) {
        return false;
    }

    public CellEditor getCellEditor(int columnIndex) {
        return null;
    }

    public Object getCellEditorValue(int columnIndex) {
        return null;
    }

    public void setCellEditorValue(int columnIndex, Object value) {
    }

    protected Menu createPopUpMenu(int x, int y) {
        Tree tree = this.viewer.getTree();
        final Menu menu = new Menu((Control)tree);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                e.display.asyncExec(new Runnable(){

                    public void run() {
                        if (!menu.isDisposed()) {
                            menu.dispose();
                        }
                    }
                });
            }
        });
        if (COCOA) {
            y += 3;
        }
        menu.setLocation(tree.toDisplay(x, y));
        return menu;
    }
}

