/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.widgets;

import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class InPlaceEditorShell {
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");

    public static Shell create(Control parent, Rectangle locationHint, int width, int height, boolean resizable) {
        Monitor monitor;
        Display display = parent.getDisplay();
        List areaList = Util.newList();
        Object object = display.getMonitors();
        int n = ((Monitor[])object).length;
        int n2 = 0;
        while (n2 < n) {
            monitor = object[n2];
            areaList.add(monitor.getClientArea());
            ++n2;
        }
        object = display.getMonitors();
        n = ((Monitor[])object).length;
        n2 = 0;
        while (n2 < n) {
            monitor = object[n2];
            areaList.add(monitor.getBounds());
            ++n2;
        }
        locationHint = new Rectangle(locationHint.x - 4, locationHint.y - 2, locationHint.width + 8, locationHint.height + 4);
        Point location = parent.toDisplay(locationHint.x, locationHint.y + locationHint.height);
        Point cursorPt = display.getCursorLocation();
        for (Rectangle area : areaList) {
            if (!area.contains(cursorPt)) continue;
            width = Math.min(width, area.width);
            if (location.y + (height = Math.min(height, area.height)) > area.y + area.height) {
                if (location.y - locationHint.height - height >= area.y) {
                    location.y -= locationHint.height + height;
                } else {
                    location.y = area.y + area.height - height;
                    if (location.x + locationHint.width + width <= area.x + area.width) {
                        location.x += locationHint.width;
                    } else if (location.x - width >= area.x) {
                        location.x -= width;
                    }
                }
            }
            location.x = Math.min(location.x, area.x + area.width - width);
            location.x = Math.max(location.x, area.x);
            break;
        }
        final Shell shell = new Shell(parent.getShell(), 4);
        shell.setSize(width, height);
        shell.setLocation(location);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                shell.setVisible(false);
            }
        });
        shell.addListener(23, new Listener(){

            public void handleEvent(Event e) {
                e.display.asyncExec(new Runnable(){

                    public void run() {
                        if (!shell.isDisposed()) {
                            shell.dispose();
                        }
                    }
                });
            }
        });
        final Listener mouseDownFilter = new Listener(){

            public void handleEvent(Event e) {
                if (!shell.isDisposed()) {
                    Control control;
                    Control control2 = control = e.widget instanceof Control ? (Control)e.widget : null;
                    if (control == null || control.getShell() != shell) {
                        e.type = 0;
                    }
                }
            }
        };
        display.addFilter(3, mouseDownFilter);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                e.display.removeFilter(3, mouseDownFilter);
            }
        });
        if (resizable) {
            shell.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e0) {
                    boolean bottom;
                    Point size = shell.getSize();
                    boolean right = e0.x >= size.x - 10;
                    boolean bl = bottom = e0.y >= size.y - 10;
                    int cursorId = !COCOA && right && bottom ? 8 : (right ? 9 : (bottom ? 7 : 0));
                    shell.setCursor(e0.display.getSystemCursor(cursorId));
                }
            });
            shell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    shell.setCursor(null);
                }
            });
            shell.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener moveListener;

                public void mouseDown(final MouseEvent e0) {
                    boolean bottom;
                    if (this.moveListener != null) {
                        return;
                    }
                    Point size = shell.getSize();
                    final boolean right = e0.x >= size.x - 10;
                    boolean bl = bottom = e0.y >= size.y - 10;
                    if (right || bottom) {
                        final Point size0 = shell.getSize();
                        this.moveListener = new MouseMoveListener(){

                            public void mouseMove(MouseEvent e1) {
                                int width = size0.x + (e1.x - e0.x) * (right ? 1 : 0);
                                int height = size0.y + (e1.y - e0.y) * (bottom ? 1 : 0);
                                width = Math.max(width, 10);
                                height = Math.max(height, 10);
                                shell.setSize(width, height);
                            }
                        };
                        shell.addMouseMoveListener(this.moveListener);
                    }
                }

                public void mouseUp(MouseEvent e) {
                    if (this.moveListener != null) {
                        shell.removeMouseMoveListener(this.moveListener);
                        this.moveListener = null;
                    }
                }
            });
        }
        return shell;
    }
}

