/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.app.widgets.FrameRateComboUtil;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.TimeCode;
import java.util.Arrays;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MediaOptionsWizardPage
extends WizardPage {
    private final MediaSource source;
    private final MediaOptions options;
    private final MediaOptions origOptions;
    private Image colorMatteImage;
    private Button customFpsButton;
    private Combo customFpsCombo;
    private Text durationText;
    private Text widthText;
    private Text heightText;
    private Button freezeRatioCheck;
    private int widthRatio;
    private int heightRatio;

    public MediaOptionsWizardPage(MediaItem mediaItem) {
        super("MediaInputOptionsWizardPage");
        this.source = mediaItem.getMediaSource();
        this.options = mediaItem.getMediaOptions();
        this.origOptions = this.options.clone();
        this.setTitle("\u30e1\u30c7\u30a3\u30a2\u30aa\u30d7\u30b7\u30e7\u30f3\uff1a" + mediaItem.getName());
    }

    public void dispose() {
        if (this.colorMatteImage != null) {
            this.colorMatteImage.dispose();
            this.colorMatteImage = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        GridBuilder gb = new GridBuilder(parent, 1, false);
        ((GridLayout)gb.getComposite().getLayout()).verticalSpacing = 0;
        this.createAlphaGroup(gb);
        gb.size(10, 10).composite(0);
        this.createFrameRateAndDurationGroup(gb);
        gb.size(10, 10).composite(0);
        this.createSizeGroup(gb);
        gb.size(10, 10).composite(0);
        this.createMiscGroup(gb);
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.setControl((Control)grid);
        this.doValidate();
    }

    private void createAlphaGroup(GridBuilder gb) {
        Group group = gb.hAlign(4).hGrab().group(0, "\u30a2\u30eb\u30d5\u30a1\u30c1\u30e3\u30f3\u30cd\u30eb");
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        GridBuilder gb2 = new GridBuilder((Composite)group, 4, false);
        Button ignoreButton = gb2.hSpan(2).hAlign(16384).button(16, "\u7121\u8996");
        gb2.hSpan(2).hAlign(16384).button(0x800008, "-").setVisible(false);
        Button straightButton = gb2.hSpan(2).hAlign(16384).button(16, "\u30b9\u30c8\u30ec\u30fc\u30c8\u30a2\u30eb\u30d5\u30a1");
        gb2.hSpan(2).hAlign(16384).button(0x800008, "-").setVisible(false);
        Button premultButton = gb2.hSpan(1).hAlign(16384).button(16, "\u4e57\u7b97\u6e08\u307f\u30a2\u30eb\u30d5\u30a1");
        gb2.hSpan(1).size(10, 10).composite(0);
        final Label matteLabel = gb2.hSpan(1).hAlign(131072).label(0, "\u30ab\u30e9\u30fc\u30de\u30c3\u30c8:");
        final Button matteButton = gb2.hSpan(1).hAlign(16384).button(0x800008, "");
        MediaOptions.AlphaType alphaType = this.options.getAlphaType();
        ignoreButton.setEnabled(this.options.isAvailable(MediaOptions.Option.IGNORE_ALPHA));
        ignoreButton.setSelection(alphaType == MediaOptions.AlphaType.IGNORE);
        straightButton.setEnabled(this.options.isAvailable(MediaOptions.Option.STRAIGHT_ALPHA));
        straightButton.setSelection(alphaType == MediaOptions.AlphaType.STRAIGHT);
        premultButton.setEnabled(this.options.isAvailable(MediaOptions.Option.PREMULTIPLIED_ALPHA));
        premultButton.setSelection(alphaType == MediaOptions.AlphaType.PREMULTIPLIED);
        if (this.options.isAvailable(MediaOptions.Option.IGNORE_ALPHA)) {
            ignoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediaOptionsWizardPage.this.options.setAlphaType(MediaOptions.AlphaType.IGNORE);
                    MediaOptionsWizardPage.this.enableControls(false, new Control[]{matteLabel, matteButton});
                    MediaOptionsWizardPage.this.doValidate();
                }
            });
        }
        if (this.options.isAvailable(MediaOptions.Option.STRAIGHT_ALPHA)) {
            straightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediaOptionsWizardPage.this.options.setAlphaType(MediaOptions.AlphaType.STRAIGHT);
                    MediaOptionsWizardPage.this.enableControls(false, new Control[]{matteLabel, matteButton});
                    MediaOptionsWizardPage.this.doValidate();
                }
            });
        }
        if (this.options.isAvailable(MediaOptions.Option.PREMULTIPLIED_ALPHA)) {
            premultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediaOptionsWizardPage.this.options.setAlphaType(MediaOptions.AlphaType.PREMULTIPLIED);
                    MediaOptionsWizardPage.this.enableControls(true, new Control[]{matteLabel, matteButton});
                    MediaOptionsWizardPage.this.doValidate();
                }
            });
            matteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ColorDialog dialog = new ColorDialog(MediaOptionsWizardPage.this.getShell());
                    dialog.setRGB(MediaOptionsWizardPage.this.toRGB(MediaOptionsWizardPage.this.options.getColorMatte()));
                    RGB rgb = dialog.open();
                    if (rgb != null) {
                        MediaOptionsWizardPage.this.options.setColorMatte(MediaOptionsWizardPage.this.toColor(rgb));
                        MediaOptionsWizardPage.this.updateColorMatteImage((Button)e.widget, rgb);
                        MediaOptionsWizardPage.this.doValidate();
                    }
                }
            });
            this.enableControls(alphaType == MediaOptions.AlphaType.PREMULTIPLIED, new Control[]{matteLabel, matteButton});
            this.updateColorMatteImage(matteButton, this.toRGB(this.options.getColorMatte()));
        } else {
            this.enableControls(false, new Control[]{matteLabel, matteButton});
            this.updateColorMatteImage(matteButton, this.toRGB(ch.kuramo.javie.api.Color.BLACK));
        }
        if (!(this.options.isAvailable(MediaOptions.Option.IGNORE_ALPHA) || this.options.isAvailable(MediaOptions.Option.STRAIGHT_ALPHA) || this.options.isAvailable(MediaOptions.Option.PREMULTIPLIED_ALPHA))) {
            this.enableControls(false, new Control[]{group});
        }
    }

    private void createFrameRateAndDurationGroup(GridBuilder gb) {
        Label durationLabel2;
        Group group = gb.hAlign(4).hGrab().group(0, "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u3068\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3");
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        GridBuilder gb2 = new GridBuilder((Composite)group, 5, false);
        Button soruceFpsButton = gb2.hSpan(3).hAlign(16384).button(16, "\u30d5\u30a1\u30a4\u30eb\u306e\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u3092\u4f7f\u7528:");
        Label soruceFpsLabel = gb2.hSpan(2).hAlign(4).hGrab().label(0, "");
        this.customFpsButton = gb2.hSpan(2).hAlign(16384).button(16, "\u6b21\u306e\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u306b\u8abf\u6574:");
        this.customFpsCombo = gb2.hSpan(2).hAlign(16384).combo(0, 0, FrameRateComboUtil.getComboItems(), "");
        Label framePerSecLabel = gb2.hSpan(1).hAlign(4).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0\uff0f\u79d2");
        gb2.hSpan(5).size(10, 10).composite(0);
        Label durationLabel = gb2.hSpan(1).hAlign(16384).label(0, "\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3:");
        if (this.options.isAvailable(MediaOptions.Option.DURATION)) {
            this.durationText = gb2.hSpan(2).hAlign(4).text(2048, "");
            durationLabel2 = gb2.hSpan(2).hAlign(4).hGrab().label(0, "");
        } else {
            this.durationText = null;
            durationLabel2 = gb2.hSpan(4).hAlign(4).hGrab().label(0, "");
        }
        Time soruceFrameDuration = this.source.getVideoFrameDuration(null);
        if (soruceFrameDuration != null && soruceFrameDuration.timeValue > 0L) {
            soruceFpsButton.setSelection(true);
            soruceFpsLabel.setText(String.valueOf(FrameRateComboUtil.toComboItem(soruceFrameDuration)) + " \u30d5\u30ec\u30fc\u30e0\uff0f\u79d2");
        } else {
            soruceFpsButton.setEnabled(false);
        }
        if (this.options.isAvailable(MediaOptions.Option.VIDEO_FRAME_DURATION)) {
            Time frameDuration = this.options.getVideoFrameDuration();
            if (frameDuration == null) {
                soruceFpsButton.setSelection(true);
                this.customFpsButton.setSelection(false);
            } else {
                soruceFpsButton.setSelection(false);
                this.customFpsButton.setSelection(true);
                this.customFpsCombo.setText(FrameRateComboUtil.toComboItem(frameDuration));
            }
            this.updateDuration(durationLabel2);
            this.customFpsCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MediaOptionsWizardPage.this.doValidate();
                    MediaOptionsWizardPage.this.updateDuration(durationLabel2);
                }
            });
            this.customFpsCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MediaOptionsWizardPage.this.doValidate();
                    MediaOptionsWizardPage.this.updateDuration(durationLabel2);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    MediaOptionsWizardPage.this.doValidate();
                    MediaOptionsWizardPage.this.updateDuration(durationLabel2);
                }
            });
        } else if (this.options.isAvailable(MediaOptions.Option.DURATION)) {
            this.enableControls(false, new Control[]{soruceFpsButton, soruceFpsLabel, this.customFpsButton, this.customFpsCombo, framePerSecLabel});
            this.updateDuration(this.durationText, durationLabel2);
            this.durationText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MediaOptionsWizardPage.this.doValidate();
                    MediaOptionsWizardPage.this.updateDuration(null, durationLabel2);
                }
            });
        } else {
            this.enableControls(false, new Control[]{soruceFpsButton, soruceFpsLabel, this.customFpsButton, this.customFpsCombo, framePerSecLabel, durationLabel, durationLabel2});
            this.updateDuration(durationLabel2);
        }
        if (!this.options.isAvailable(MediaOptions.Option.VIDEO_FRAME_DURATION) && !this.options.isAvailable(MediaOptions.Option.DURATION)) {
            this.enableControls(false, new Control[]{group});
        }
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void createSizeGroup(GridBuilder gb) {
        Group group = gb.hAlign(4).hGrab().group(0, "\u30b5\u30a4\u30ba");
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        GridBuilder gb2 = new GridBuilder((Composite)group, 3, false);
        VideoBounds bounds = this.source.getVideoFrameBounds(this.options);
        if (this.options.isAvailable(MediaOptions.Option.SIZE)) {
            gb2.hSpan(1).hAlign(131072).label(0, "\u5e45:");
            this.widthText = gb2.hSpan(1).hAlign(4).width(70).text(2048, String.valueOf(bounds.width));
            this.freezeRatioCheck = gb2.span(1, 2).hAlign(16384).hGrab().button(32, "\u7e26\u6a2a\u6bd4\u3092\u56fa\u5b9a");
            gb2.hSpan(1).hAlign(131072).label(0, "\u9ad8\u3055:");
            this.heightText = gb2.hSpan(1).hAlign(4).width(70).tabAfter((Control)this.widthText).text(2048, String.valueOf(bounds.height));
            final ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MediaOptionsWizardPage.this.updateSize((Control)e.widget, this);
                    MediaOptionsWizardPage.this.doValidate();
                }
            };
            this.widthText.addModifyListener(modifyListener);
            this.heightText.addModifyListener(modifyListener);
            this.freezeRatioCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediaOptionsWizardPage.this.updateSize((Control)MediaOptionsWizardPage.this.freezeRatioCheck, modifyListener);
                    MediaOptionsWizardPage.this.doValidate();
                }
            });
            this.updateSize(null, modifyListener);
        } else {
            Label widthLabel1 = gb2.hSpan(1).hAlign(131072).label(0, "\u5e45:");
            Label widthLabel2 = gb2.hSpan(2).hAlign(16384).label(0, String.valueOf(bounds.width));
            Label heightLabel1 = gb2.hSpan(1).hAlign(131072).label(0, "\u9ad8\u3055:");
            Label heightLabel2 = gb2.hSpan(2).hAlign(16384).label(0, String.valueOf(bounds.height));
            this.enableControls(false, new Control[]{group, widthLabel1, widthLabel2, heightLabel1, heightLabel2});
        }
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void createMiscGroup(GridBuilder gb) {
        Group group = gb.hAlign(4).hGrab().group(0, "\u305d\u306e\u4ed6\u306e\u30aa\u30d7\u30b7\u30e7\u30f3");
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        GridBuilder gb2 = new GridBuilder((Composite)group, 1, false);
        Button flipVertCheck = gb2.hSpan(1).hAlign(16384).button(32, "\u4e0a\u4e0b\u53cd\u8ee2");
        if (this.options.isAvailable(MediaOptions.Option.FLIP_VERTICAL)) {
            flipVertCheck.setSelection(this.options.isFlipVertical());
            flipVertCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediaOptionsWizardPage.this.options.setFlipVertical(((Button)e.widget).getSelection());
                    MediaOptionsWizardPage.this.doValidate();
                }
            });
        } else {
            flipVertCheck.setEnabled(false);
        }
        if (!this.options.isAvailable(MediaOptions.Option.FLIP_VERTICAL)) {
            this.enableControls(false, new Control[]{group});
        }
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void enableControls(boolean enabled, Control ... controls) {
        Color disabledColor = this.getShell().getDisplay().getSystemColor(16);
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label || c instanceof Group) {
                c.setForeground(enabled ? c.getParent().getForeground() : disabledColor);
            } else {
                c.setEnabled(enabled);
            }
            ++n2;
        }
    }

    private RGB toRGB(ch.kuramo.javie.api.Color color) {
        return new RGB((int)(color.r * 255.0), (int)(color.g * 255.0), (int)(color.b * 255.0));
    }

    private ch.kuramo.javie.api.Color toColor(RGB rgb) {
        return new ch.kuramo.javie.api.Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0);
    }

    private void updateColorMatteImage(Button button, RGB rgb) {
        PaletteData palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), rgb});
        byte[] data = new byte[64];
        Arrays.fill(data, (byte)-1);
        ImageData imageData = new ImageData(32, 16, 1, palette, 1, data);
        Image image = new Image((Device)button.getDisplay(), imageData);
        button.setImage(image);
        if (this.colorMatteImage != null) {
            this.colorMatteImage.dispose();
        }
        this.colorMatteImage = image;
    }

    private void updateDuration(Label label) {
        Time duration = this.source.getDuration(this.options);
        Time frameDuration = this.source.getVideoFrameDuration(this.options);
        String timeCode = TimeCode.toTimeCode((Time)duration, (Time)frameDuration);
        int base = (int)Math.round((double)frameDuration.timeScale / (double)frameDuration.timeValue);
        boolean drop = timeCode.indexOf(59) != -1;
        label.setText(String.format("%s (\u30d9\u30fc\u30b9 %d%s) , %d\u30d5\u30ec\u30fc\u30e0", timeCode, base, drop ? "\u30c9\u30ed\u30c3\u30d7" : "", duration.toFrameNumber(frameDuration)));
    }

    private void updateDuration(Text text, Label label) {
        Time duration = this.source.getDuration(this.options);
        Time frameDuration = this.source.getVideoFrameDuration(this.options);
        if (frameDuration.timeValue == 0L) {
            frameDuration = FrameDuration.FPS_59_94;
        }
        String timeCode = TimeCode.toTimeCode((Time)duration, (Time)frameDuration);
        int base = (int)Math.round((double)frameDuration.timeScale / (double)frameDuration.timeValue);
        boolean drop = timeCode.indexOf(59) != -1;
        label.setText(String.format(" = %s (\u30d9\u30fc\u30b9 %d%s)", timeCode, base, drop ? "\u30c9\u30ed\u30c3\u30d7" : ""));
        if (text != null) {
            text.setText(timeCode);
        }
    }

    private void updateSize(Control control, ModifyListener modifyListener) {
        String wStr = null;
        String hStr = null;
        int width = 0;
        int height = 0;
        wStr = this.widthText.getText().trim();
        try {
            width = Integer.parseInt(wStr);
        }
        catch (NumberFormatException numberFormatException) {
            width = 0;
        }
        hStr = this.heightText.getText().trim();
        try {
            height = Integer.parseInt(hStr);
        }
        catch (NumberFormatException numberFormatException) {
            height = 0;
        }
        if (this.freezeRatioCheck.getSelection()) {
            if (control == this.widthText && width > 0) {
                height = Math.max(1, width * this.heightRatio / this.widthRatio);
                this.heightText.removeModifyListener(modifyListener);
                this.heightText.setText(String.valueOf(height));
                this.heightText.addModifyListener(modifyListener);
            } else if (control == this.heightText && height > 0) {
                width = Math.max(1, height * this.widthRatio / this.heightRatio);
                this.widthText.removeModifyListener(modifyListener);
                this.widthText.setText(String.valueOf(width));
                this.widthText.addModifyListener(modifyListener);
            }
        } else if ((control == null || control == this.widthText || control == this.heightText) && width > 0 && height > 0) {
            int gcd = this.gcd(width, height);
            this.widthRatio = width / gcd;
            this.heightRatio = height / gcd;
            this.freezeRatioCheck.setText(String.format("\u7e26\u6a2a\u6bd4\u3092%d:%d\u306b\u56fa\u5b9a", this.widthRatio, this.heightRatio));
            this.freezeRatioCheck.getParent().layout(new Control[]{this.freezeRatioCheck});
        }
    }

    private int gcd(int x, int y) {
        while (y != 0) {
            int t = x % y;
            x = y;
            y = t;
        }
        return x;
    }

    private void doValidate() {
        this.setPageComplete(false);
        if (this.options.isAvailable(MediaOptions.Option.VIDEO_FRAME_DURATION) && this.customFpsButton.getSelection()) {
            double fps;
            String fpsStr = this.customFpsCombo.getText().trim();
            if (fpsStr.length() == 0) {
                this.setErrorMessage("\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            try {
                fps = Double.parseDouble(fpsStr);
            }
            catch (NumberFormatException numberFormatException) {
                fps = 0.0;
            }
            if (fps < 1.0) {
                this.setErrorMessage("\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u306b\u306f1\u4ee5\u4e0a\u306e\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
            this.options.setVideoFrameDuration(FrameRateComboUtil.toFrameDuration(fpsStr));
        } else if (this.options.isAvailable(MediaOptions.Option.DURATION)) {
            String durationStr;
            Time frameDuration = this.source.getVideoFrameDuration(this.options);
            if (frameDuration.timeValue == 0L) {
                frameDuration = FrameDuration.FPS_59_94;
            }
            if ((durationStr = this.durationText.getText().trim()).length() == 0) {
                this.setErrorMessage("\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            long frames = TimeCode.parseTimeCode((String)durationStr, (Time)frameDuration);
            if (frames <= 0L) {
                this.setErrorMessage("\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3\u306f1\u30d5\u30ec\u30fc\u30e0\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002");
                return;
            }
            this.options.setDuration(Time.fromFrameNumber((long)frames, (Time)frameDuration));
        }
        if (this.options.isAvailable(MediaOptions.Option.SIZE)) {
            String wStr = null;
            String hStr = null;
            int width = 0;
            int height = 0;
            wStr = this.widthText.getText().trim();
            try {
                width = Integer.parseInt(wStr);
            }
            catch (NumberFormatException numberFormatException) {
                width = 0;
            }
            hStr = this.heightText.getText().trim();
            try {
                height = Integer.parseInt(hStr);
            }
            catch (NumberFormatException numberFormatException) {
                height = 0;
            }
            if (wStr.length() == 0) {
                this.setErrorMessage("\u5e45\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            if (width < 1 || width > 8192) {
                this.setErrorMessage(String.format("\u5e45\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192));
                return;
            }
            if (hStr.length() == 0) {
                this.setErrorMessage("\u9ad8\u3055\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            if (height < 1 || height > 8192) {
                this.setErrorMessage(String.format("\u9ad8\u3055\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192));
                return;
            }
            this.options.setSize(new Size2i(width, height));
        }
        this.setErrorMessage(null);
        this.setPageComplete(!this.options.equals((Object)this.origOptions));
    }

    public MediaOptions getMediaOptions() {
        return this.options;
    }
}

