/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl;

import com.jogamp.opengl.impl.GLContextImpl;
import javax.media.opengl.GLException;

public class GLContextLock {
    protected static final boolean DEBUG = GLContextImpl.DEBUG;
    private SyncData sdata = new SyncData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lock() throws GLException {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            Thread thread = Thread.currentThread();
            if (this.sdata.owner == null) {
                this.sdata.owner = thread;
                if (DEBUG) {
                    this.sdata.lockedStack = new Exception("Error: Previously made current (1) by " + this.sdata.owner + ", lock: " + this);
                }
            } else if (this.sdata.owner != thread) {
                while (this.sdata.owner != null) {
                    if (this.sdata.failFastMode) {
                        if (null != this.sdata.lockedStack) {
                            this.sdata.lockedStack.printStackTrace();
                        }
                        throw new GLException("Error: Attempt to make context current on thread " + thread + " which is already current on thread " + this.sdata.owner);
                    }
                    try {
                        ++this.sdata.waiters;
                        this.sdata.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new GLException(interruptedException);
                    }
                    finally {
                        --this.sdata.waiters;
                    }
                }
                this.sdata.owner = thread;
                if (DEBUG) {
                    this.sdata.lockedStack = new Exception("Previously made current (2) by " + this.sdata.owner + ", lock: " + this);
                }
            } else {
                throw new GLException("Attempt to make the same context current twice on thread " + thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock() throws GLException {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            Thread thread = Thread.currentThread();
            if (this.sdata.owner != thread) {
                if (this.sdata.owner != null) {
                    throw new GLException("Attempt by thread " + thread + " to release context owned by thread " + this.sdata.owner);
                }
                throw new GLException("Attempt by thread " + thread + " to release unowned context");
            }
            this.sdata.owner = null;
            this.sdata.lockedStack = null;
            this.sdata.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isHeld() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return Thread.currentThread() == this.sdata.owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFailFastMode(boolean bl) {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            this.sdata.failFastMode = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getFailFastMode() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return this.sdata.failFastMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasWaiters() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return 0 != this.sdata.waiters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Exception getLockedStack() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return this.sdata.lockedStack;
        }
    }

    static class SyncData {
        boolean failFastMode = true;
        Thread owner = null;
        int waiters = 0;
        Exception lockedStack = null;

        SyncData() {
        }
    }
}

