/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.glu.gl2.nurbs;

import com.jogamp.opengl.impl.glu.gl2.nurbs.GL2Backend;
import com.jogamp.opengl.impl.glu.nurbs.Backend;
import com.jogamp.opengl.impl.glu.nurbs.CArrayOfFloats;
import com.jogamp.opengl.impl.glu.nurbs.DisplayList;
import com.jogamp.opengl.impl.glu.nurbs.Knotvector;
import com.jogamp.opengl.impl.glu.nurbs.Mapdesc;
import com.jogamp.opengl.impl.glu.nurbs.Maplist;
import com.jogamp.opengl.impl.glu.nurbs.O_curve;
import com.jogamp.opengl.impl.glu.nurbs.O_nurbscurve;
import com.jogamp.opengl.impl.glu.nurbs.O_nurbssurface;
import com.jogamp.opengl.impl.glu.nurbs.O_pwlcurve;
import com.jogamp.opengl.impl.glu.nurbs.O_surface;
import com.jogamp.opengl.impl.glu.nurbs.O_trim;
import com.jogamp.opengl.impl.glu.nurbs.Property;
import com.jogamp.opengl.impl.glu.nurbs.Quilt;
import com.jogamp.opengl.impl.glu.nurbs.Renderhints;
import com.jogamp.opengl.impl.glu.nurbs.Subdivider;
import java.lang.reflect.Method;
import javax.media.opengl.glu.GLUnurbs;

public class GLUgl2nurbsImpl
implements GLUnurbs {
    public static final int CT_NONE = 0;
    public static final int CT_NURBSCURVE = 1;
    public static final int CT_NPWLCURVE = 2;
    private boolean autoloadmode;
    private int callBackFlag;
    private Object errorCallback;
    Maplist maplist;
    private int isDataValid;
    private int inCurve;
    private O_curve currentCurve;
    private boolean inTrim;
    private boolean playBack;
    private O_curve nextCurve;
    private int isCurveModified;
    private Renderhints renderhints;
    private DisplayList dl;
    private Subdivider subdivider;
    private Backend backend;
    private O_pwlcurve nextPwlcurve;
    private O_nurbscurve nextNurbscurve;
    private int inSurface;
    private boolean isTrimModified;
    private boolean isDataSurfaceModified;
    private int numTrims;
    private O_surface currentSurface;
    private O_trim nextTrim;
    private O_nurbssurface nextNurbssurface;
    private boolean isSurfaceModified;

    public GLUgl2nurbsImpl() {
        this.maplist = new Maplist(this.backend);
        this.renderhints = new Renderhints();
        this.subdivider = new Subdivider();
        this.redefineMaps();
        this.defineMap(3506, 0, 3);
        this.defineMap(3474, 0, 3);
        this.defineMap(3507, 0, 1);
        this.defineMap(3475, 0, 1);
        this.defineMap(3508, 0, 2);
        this.defineMap(3476, 0, 2);
        this.defineMap(3509, 0, 3);
        this.defineMap(3477, 0, 3);
        this.defineMap(3510, 1, 4);
        this.defineMap(3478, 1, 4);
        this.defineMap(3512, 1, 4);
        this.defineMap(3480, 1, 4);
        this.defineMap(3511, 0, 3);
        this.defineMap(3479, 0, 3);
        this.defineMap(3504, 0, 4);
        this.defineMap(3472, 0, 4);
        this.defineMap(3505, 0, 1);
        this.defineMap(3473, 0, 1);
        this.setnurbsproperty(3479, 10, 6.0f);
        this.setnurbsproperty(3480, 10, 6.0f);
        this.setnurbsproperty(3511, 10, 6.0f);
        this.setnurbsproperty(3512, 10, 6.0f);
        this.setnurbsproperty(3479, 1, 50.0f);
        this.setnurbsproperty(3480, 1, 50.0f);
        this.setnurbsproperty(3511, 1, 50.0f);
        this.setnurbsproperty(3512, 1, 50.0f);
        this.setnurbsproperty(3479, 20, 0.5f);
        this.setnurbsproperty(3480, 20, 0.5f);
        this.setnurbsproperty(3511, 20, 0.5f);
        this.setnurbsproperty(3512, 20, 0.5f);
        this.setnurbsproperty(3479, 6, 100.0f);
        this.setnurbsproperty(3480, 6, 100.0f);
        this.setnurbsproperty(3511, 6, 100.0f);
        this.setnurbsproperty(3512, 6, 100.0f);
        this.setnurbsproperty(3479, 10, 6.0f);
        this.set_domain_distance_u_rate(100.0);
        this.set_domain_distance_v_rate(100.0);
        this.set_is_domain_distance_sampling(0);
        this.autoloadmode = true;
        this.callBackFlag = 0;
        this.errorCallback = null;
    }

    private void set_domain_distance_u_rate(double d) {
        this.subdivider.set_domain_distance_u_rate(d);
    }

    private void set_domain_distance_v_rate(double d) {
        this.subdivider.set_domain_distance_v_rate(d);
    }

    public void bgncurve() {
        O_curve o_curve = new O_curve();
        this.thread("do_bgncurve", o_curve);
    }

    private void thread(String string, Object object) {
        Class[] classArray = new Class[]{object.getClass()};
        try {
            Method method = this.getClass().getMethod(string, classArray);
            if (this.dl != null) {
                this.dl.append(this, method, object);
            } else {
                method.invoke((Object)this, object);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void thread2(String string) {
        try {
            Method method = this.getClass().getMethod(string, null);
            if (this.dl != null) {
                this.dl.append(this, method, null);
            } else {
                method.invoke((Object)this, (Object[])null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void do_bgncurve(O_curve o_curve) {
        if (this.inCurve > 0) {
            this.do_nurbserror(6);
            this.endcurve();
        }
        this.inCurve = 1;
        this.currentCurve = o_curve;
        this.currentCurve.curvetype = 0;
        if (this.inTrim) {
            if (!this.nextCurve.equals(o_curve)) {
                this.isCurveModified = 1;
                this.nextCurve = o_curve;
            }
        } else {
            if (!this.playBack) {
                this.bgnrender();
            }
            this.isDataValid = 1;
        }
        this.nextCurve = o_curve.next;
        this.nextPwlcurve = o_curve.o_pwlcurve;
        this.nextNurbscurve = o_curve.o_nurbscurve;
    }

    public void do_bgnsurface(O_surface o_surface) {
        if (this.inSurface > 0) {
            this.do_nurbserror(27);
            this.endsurface();
        }
        this.inSurface = 1;
        if (!this.playBack) {
            this.bgnrender();
        }
        this.isTrimModified = false;
        this.isDataSurfaceModified = false;
        this.isDataValid = 1;
        this.numTrims = 0;
        this.currentSurface = o_surface;
        this.nextTrim = o_surface.o_trim;
        this.nextNurbssurface = o_surface.o_nurbssurface;
    }

    public void endcurve() {
        this.thread2("do_endcurve");
    }

    public void do_endsurface() {
        if (this.inTrim) {
            this.do_nurbserror(12);
            this.endtrim();
        }
        if (this.inSurface <= 0) {
            this.do_nurbserror(13);
            return;
        }
        this.inSurface = 0;
        this.nextNurbssurface = null;
        if (this.isDataValid <= 0) {
            return;
        }
        if (this.nextTrim != null) {
            this.isTrimModified = true;
            this.nextTrim = null;
        }
        if (this.numTrims > 0) {
            // empty if block
        }
        this.subdivider.beginQuilts(new GL2Backend());
        O_nurbssurface o_nurbssurface = this.currentSurface.o_nurbssurface;
        while (o_nurbssurface != null) {
            this.subdivider.addQuilt(o_nurbssurface.bezier_patches);
            o_nurbssurface = o_nurbssurface.next;
        }
        this.subdivider.endQuilts();
        this.subdivider.drawSurfaces();
        if (!this.playBack) {
            this.endrender();
        }
    }

    public void do_endcurve() {
        if (this.inCurve <= 0) {
            this.do_nurbserror(7);
            return;
        }
        this.inCurve = 0;
        this.nextCurve = null;
        if (this.currentCurve.curvetype == 1) {
            // empty if block
        }
        if (!this.inTrim) {
            if (this.isDataValid <= 0) {
                return;
            }
            if (this.currentCurve.curvetype == 1) {
                this.subdivider.beginQuilts(new GL2Backend());
                O_nurbscurve o_nurbscurve = this.currentCurve.o_nurbscurve;
                while (o_nurbscurve != null) {
                    this.subdivider.addQuilt(o_nurbscurve.bezier_curves);
                    o_nurbscurve = o_nurbscurve.next;
                }
                this.subdivider.endQuilts();
                this.subdivider.drawCurves();
                if (!this.playBack) {
                    this.endrender();
                }
            } else {
                if (!this.playBack) {
                    this.endrender();
                }
                this.do_nurbserror(9);
            }
        }
    }

    private void do_nurbserror(int n) {
    }

    private void bgnrender() {
        if (this.autoloadmode) {
            this.loadGLMatrices();
        }
    }

    private void loadGLMatrices() {
    }

    private void endrender() {
    }

    public void nurbscurve(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        Mapdesc mapdesc = this.maplist.locate(n4);
        if (mapdesc == null) {
            this.do_nurbserror(35);
            this.isDataValid = 0;
            return;
        }
        if (fArray2 == null) {
            this.do_nurbserror(36);
            this.isDataValid = 0;
            return;
        }
        if (n2 < 0) {
            this.do_nurbserror(34);
            this.isDataValid = 0;
            return;
        }
        Knotvector knotvector = new Knotvector(n, n2, n3, fArray);
        if (!this.do_check_knots(knotvector, "curve")) {
            return;
        }
        O_nurbscurve o_nurbscurve = new O_nurbscurve(n4);
        o_nurbscurve.bezier_curves = new Quilt(mapdesc);
        CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(fArray2);
        o_nurbscurve.bezier_curves.toBezier(knotvector, cArrayOfFloats, mapdesc.getNCoords());
        this.thread("do_nurbscurve", o_nurbscurve);
    }

    public boolean do_check_knots(Knotvector knotvector, String string) {
        int n = knotvector.validate();
        if (n > 0) {
            this.do_nurbserror(n);
            if (this.renderhints.errorchecking != 0) {
                knotvector.show(string);
            }
        }
        return n <= 0;
    }

    public void do_nurbscurve(O_nurbscurve o_nurbscurve) {
        if (this.inCurve <= 0) {
            this.bgncurve();
            this.inCurve = 2;
        }
        if (o_nurbscurve.used) {
            this.do_nurbserror(23);
            this.isDataValid = 0;
            return;
        }
        o_nurbscurve.used = true;
        if (this.currentCurve.curvetype == 0) {
            this.currentCurve.curvetype = 1;
        } else if (this.currentCurve.curvetype != 1) {
            this.do_nurbserror(24);
            this.isDataValid = 0;
            return;
        }
        if (!o_nurbscurve.equals(this.currentCurve.o_nurbscurve)) {
            this.isCurveModified = 1;
            this.currentCurve.o_nurbscurve = o_nurbscurve;
        }
        this.nextNurbscurve = o_nurbscurve.next;
        if (!this.currentCurve.equals(o_nurbscurve.owner)) {
            this.isCurveModified = 1;
            o_nurbscurve.owner = this.currentCurve;
        }
        if (o_nurbscurve.owner == null) {
            this.isCurveModified = 1;
        }
        if (this.inCurve == 2) {
            this.endcurve();
        }
    }

    public void do_nurbssurface(O_nurbssurface o_nurbssurface) {
        if (this.inSurface <= 0) {
            this.bgnsurface();
            this.inSurface = 2;
        }
        if (o_nurbssurface.used) {
            this.do_nurbserror(25);
            this.isDataValid = 0;
            return;
        }
        o_nurbssurface.used = true;
        if (!o_nurbssurface.equals(this.nextNurbscurve)) {
            this.isSurfaceModified = true;
            this.currentSurface.o_nurbssurface = o_nurbssurface;
        }
        if (!this.currentSurface.equals(o_nurbssurface.owner)) {
            this.isSurfaceModified = true;
            o_nurbssurface.owner = this.currentSurface;
        }
        this.nextNurbssurface = o_nurbssurface.next;
        if (this.inSurface == 2) {
            this.endsurface();
        }
    }

    public void redefineMaps() {
        this.maplist.initialize();
    }

    public void defineMap(int n, int n2, int n3) {
        this.maplist.define(n, n2, n3);
    }

    public void setnurbsproperty(int n, int n2, float f) {
        Mapdesc mapdesc = this.maplist.locate(n);
        if (mapdesc == null) {
            this.do_nurbserror(35);
            return;
        }
        if (!mapdesc.isProperty(n2)) {
            this.do_nurbserror(26);
            return;
        }
        Property property = new Property(n, n2, f);
        this.thread("do_setnurbsproperty2", property);
    }

    public void do_setnurbsproperty2(Property property) {
        Mapdesc mapdesc = this.maplist.find(property.type);
        mapdesc.setProperty(property.tag, property.value);
    }

    public void do_setnurbsproperty(Property property) {
        this.renderhints.setProperty(property);
    }

    public void set_is_domain_distance_sampling(int n) {
        this.subdivider.set_is_domain_distance_sampling(n);
    }

    public void bgnsurface() {
        O_surface o_surface = new O_surface();
        this.thread("do_bgnsurface", o_surface);
    }

    public void endsurface() {
        this.thread2("do_endsurface");
    }

    private void endtrim() {
    }

    public void nurbssurface(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4, float[] fArray3, int n5, int n6, int n7) {
        Mapdesc mapdesc = this.maplist.locate(n7);
        if (mapdesc == null) {
            this.do_nurbserror(35);
            this.isDataValid = 0;
            return;
        }
        if (n3 < 0 || n4 < 0) {
            this.do_nurbserror(34);
            this.isDataValid = 0;
            return;
        }
        Knotvector knotvector = new Knotvector(n, n3, n5, fArray);
        if (!this.do_check_knots(knotvector, "surface")) {
            return;
        }
        Knotvector knotvector2 = new Knotvector(n2, n4, n6, fArray2);
        if (!this.do_check_knots(knotvector2, "surface")) {
            return;
        }
        O_nurbssurface o_nurbssurface = new O_nurbssurface(n7);
        o_nurbssurface.bezier_patches = new Quilt(mapdesc);
        CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(fArray3);
        o_nurbssurface.bezier_patches.toBezier(knotvector, knotvector2, cArrayOfFloats, mapdesc.getNCoords());
        this.thread("do_nurbssurface", o_nurbssurface);
    }
}

