/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.glu.nurbs;

import com.jogamp.opengl.impl.glu.nurbs.CArrayOfFloats;
import com.jogamp.opengl.impl.glu.nurbs.CArrayOfQuiltspecs;
import com.jogamp.opengl.impl.glu.nurbs.Mapdesc;
import com.jogamp.opengl.impl.glu.nurbs.Quilt;

public class Curve {
    private static final int MAXCOORDS = 5;
    private static final int MAXORDER = 24;
    public Curve next;
    private Mapdesc mapdesc;
    private boolean needsSampling;
    private int cullval;
    private int stride;
    private int order;
    private float[] range;
    public float stepsize;
    private float minstepsize;
    float[] spts = new float[120];
    static final /* synthetic */ boolean $assertionsDisabled;

    public Curve(Quilt quilt, float[] fArray, float[] fArray2, Curve curve) {
        this.mapdesc = quilt.mapdesc;
        this.next = curve;
        this.needsSampling = this.mapdesc.isRangeSampling();
        this.cullval = this.mapdesc.isCulling() ? 1 : 0;
        this.order = quilt.qspec.get((int)0).order;
        this.stride = 5;
        CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(quilt.cpts.getArray(), 0);
        CArrayOfQuiltspecs cArrayOfQuiltspecs = quilt.qspec;
        cArrayOfFloats.raisePointerBy(cArrayOfQuiltspecs.get().offset);
        cArrayOfFloats.raisePointerBy(cArrayOfQuiltspecs.get().index * cArrayOfQuiltspecs.get().order * cArrayOfQuiltspecs.get().stride);
        if (this.needsSampling) {
            this.mapdesc.xformSampling(cArrayOfFloats, cArrayOfQuiltspecs.get().order, cArrayOfQuiltspecs.get().stride, this.spts, this.stride);
        }
        if (this.cullval == 1) {
            // empty if block
        }
        this.range = new float[3];
        this.range[0] = cArrayOfQuiltspecs.get().breakpoints[cArrayOfQuiltspecs.get().index];
        this.range[1] = cArrayOfQuiltspecs.get().breakpoints[cArrayOfQuiltspecs.get().index + 1];
        this.range[2] = this.range[1] - this.range[0];
        if (this.range[0] != fArray[0]) {
            // empty if block
        }
        if (this.range[1] != fArray2[0]) {
            // empty if block
        }
    }

    public int cullCheck() {
        if (this.cullval == 1) {
            // empty if block
        }
        return 1;
    }

    public void getStepSize() {
        this.minstepsize = 0.0f;
        if (this.mapdesc.isConstantSampling()) {
            this.setstepsize(this.mapdesc.maxrate);
        } else if (this.mapdesc.isDomainSampling()) {
            this.setstepsize(this.mapdesc.maxrate * this.range[2]);
        } else {
            if (!$assertionsDisabled && this.order > 24) {
                throw new AssertionError();
            }
            float[][] fArray = new float[24][5];
            int n = 24;
            boolean bl = false;
            if (!bl) {
                this.setstepsize(this.mapdesc.maxrate);
            } else {
                float f = this.mapdesc.getProperty(1);
                if (!this.mapdesc.isParametricDistanceSampling() && !this.mapdesc.isPathLengthSampling()) {
                    this.setstepsize(this.mapdesc.maxrate);
                }
            }
        }
    }

    private void setstepsize(float f) {
        this.minstepsize = this.stepsize = f >= 1.0f ? this.range[2] / f : this.range[2];
    }

    public void clamp() {
        if (this.stepsize < this.minstepsize) {
            this.stepsize = this.mapdesc.clampfactor * this.minstepsize;
        }
    }

    public boolean needsSamplingSubdivision() {
        return this.stepsize < this.minstepsize;
    }

    static {
        $assertionsDisabled = !Curve.class.desiredAssertionStatus();
    }
}

