/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.windows.wgl.awt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.impl.jawt.windows.Win32SunJDKReflection;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.GLGraphicsConfigurationFactoryImpl;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.nativewindow.windows.WindowsGraphicsDevice;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public class WindowsAWTWGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactoryImpl {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");

    public WindowsAWTWGLGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory((Class)AWTGraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        GraphicsDevice graphicsDevice = null;
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createScreenDevice((int)-1, (int)0);
            if (DEBUG) {
                System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: creating default device: " + abstractGraphicsScreen);
            }
        }
        AWTGraphicsScreen aWTGraphicsScreen = (AWTGraphicsScreen)abstractGraphicsScreen;
        graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice();
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only GLCapabilitiesChooser objects");
        }
        if (DEBUG) {
            System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: got " + abstractGraphicsScreen);
        }
        WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(0);
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen((AbstractGraphicsDevice)windowsGraphicsDevice, aWTGraphicsScreen.getIndex());
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)windowsGraphicsDevice);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(((GLCapabilitiesImmutable)capabilitiesImmutable).getGLProfile());
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, (AbstractGraphicsScreen)defaultGraphicsScreen);
        if (windowsWGLGraphicsConfiguration == null) {
            throw new GLException("Unable to choose a GraphicsConfiguration: " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + defaultGraphicsScreen);
        }
        GraphicsConfiguration graphicsConfiguration = null;
        windowsWGLGraphicsConfiguration.preselectGraphicsConfiguration(gLDrawableFactory, null);
        if (1 <= windowsWGLGraphicsConfiguration.getPixelFormatID()) {
            graphicsConfiguration = Win32SunJDKReflection.graphicsConfigurationGet((GraphicsDevice)graphicsDevice, (int)windowsWGLGraphicsConfiguration.getPixelFormatID());
            if (DEBUG) {
                System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: Found new AWT PFD ID " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + windowsWGLGraphicsConfiguration);
            }
        }
        if (null == graphicsConfiguration) {
            int n;
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            int[] nArray = new int[graphicsConfigurationArray.length];
            ArrayHashSet arrayHashSet = new ArrayHashSet();
            for (n = 0; n < graphicsConfigurationArray.length; ++n) {
                GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[n];
                nArray[n] = Win32SunJDKReflection.graphicsConfigurationGetPixelFormatID((GraphicsConfiguration)graphicsConfiguration2);
                arrayHashSet.add((Object)new Integer(nArray[n]));
                if (!DEBUG) continue;
                System.err.println("AWT pfd[" + n + "] " + nArray[n]);
            }
            if (DEBUG) {
                System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: PFD IDs: " + nArray.length + ", unique: " + arrayHashSet.size());
            }
            windowsWGLGraphicsConfiguration.preselectGraphicsConfiguration(gLDrawableFactory, nArray);
            n = arrayHashSet.indexOf((Object)new Integer(windowsWGLGraphicsConfiguration.getPixelFormatID()));
            if (0 > n) {
                graphicsConfiguration = graphicsConfigurationArray[n];
                if (DEBUG) {
                    System.err.println("WindowsAWTWGLGraphicsConfigurationFactory: Found matching AWT PFD ID " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + windowsWGLGraphicsConfiguration);
                }
            }
        }
        if (null == graphicsConfiguration) {
            throw new GLException("Unable to determine GraphicsConfiguration: " + windowsWGLGraphicsConfiguration);
        }
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, windowsWGLGraphicsConfiguration.getChosenCapabilities(), windowsWGLGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, (AbstractGraphicsConfiguration)windowsWGLGraphicsConfiguration);
    }
}

