/*
 * Decompiled with CFR 0.152.
 */
package com.iabcinc.mapping.voronoi;

import com.iabcinc.mapping.voronoi.Point;

public class Bounds {
    double topY;
    double bottomY;
    double leftX;
    double rightX;
    private boolean initialized = false;

    public void include(Point pt) {
        if (!this.initialized) {
            this.leftX = pt.getX();
            this.rightX = pt.getX();
            this.topY = pt.getY();
            this.bottomY = pt.getY();
            this.initialized = true;
            return;
        }
        this.leftX = Math.min(this.leftX, pt.getX());
        this.topY = Math.max(this.topY, pt.getY());
        this.rightX = Math.max(this.rightX, pt.getX());
        this.bottomY = Math.min(this.bottomY, pt.getY());
    }

    public void include(Bounds bounds) {
        if (!this.initialized) {
            this.leftX = bounds.leftX;
            this.rightX = bounds.rightX;
            this.topY = bounds.topY;
            this.bottomY = bounds.bottomY;
            this.initialized = true;
            return;
        }
        this.leftX = Math.min(bounds.leftX, this.leftX);
        this.rightX = Math.max(bounds.rightX, this.rightX);
        this.topY = Math.max(bounds.topY, this.topY);
        this.bottomY = Math.min(bounds.bottomY, this.bottomY);
    }

    public boolean contains(double x, double y) {
        return x > this.leftX && x < this.rightX && y > this.bottomY && y < this.topY;
    }

    public boolean contains(Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(Bounds bounds) {
        return this.contains(bounds.rightX, bounds.topY) && this.contains(bounds.leftX, bounds.bottomY);
    }

    public Point getUpperLeft() {
        return new Point(this.leftX, this.topY);
    }

    public Point getLowerRight() {
        return new Point(this.rightX, this.bottomY);
    }
}

