/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.windows.wgl;

import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.impl.windows.GDI;
import com.jogamp.opengl.impl.GLContextImpl;
import com.jogamp.opengl.impl.GLContextShareSet;
import com.jogamp.opengl.impl.GLDrawableImpl;
import com.jogamp.opengl.impl.windows.wgl.WGL;
import com.jogamp.opengl.impl.windows.wgl.WGLExt;
import com.jogamp.opengl.impl.windows.wgl.WGLExtImpl;
import com.jogamp.opengl.impl.windows.wgl.WGLExtProcAddressTable;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawableFactory;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsWGLContext
extends GLContextImpl {
    static final Map functionNameMap = new HashMap();
    static final Map extensionNameMap;
    private boolean wglGetExtensionsStringEXTInitialized;
    private boolean wglGetExtensionsStringEXTAvailable;
    private boolean wglMakeContextCurrentInitialized;
    private boolean wglMakeContextCurrentAvailable;
    private WGLExt wglExt;
    private WGLExtProcAddressTable wglExtProcAddressTable;

    WindowsWGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    protected void resetState() {
        this.wglGetExtensionsStringEXTInitialized = false;
        this.wglGetExtensionsStringEXTAvailable = false;
        this.wglMakeContextCurrentInitialized = false;
        this.wglMakeContextCurrentAvailable = false;
        this.wglExtProcAddressTable = null;
    }

    public Object getPlatformGLExtensions() {
        return this.getWGLExt();
    }

    final WGLExt getWGLExt() {
        if (this.wglExt == null) {
            this.wglExt = new WGLExtImpl(this);
        }
        return this.wglExt;
    }

    public final boolean isGLReadDrawableAvailable() {
        if (!this.wglMakeContextCurrentInitialized && null != this.getWGLExtProcAddressTable()) {
            WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)this.drawable.getFactoryImpl();
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
            switch (windowsWGLDrawableFactory.isReadDrawableAvailable(abstractGraphicsDevice)) {
                case 1: {
                    this.wglMakeContextCurrentAvailable = true;
                    this.wglMakeContextCurrentInitialized = true;
                    break;
                }
                case 0: {
                    this.wglMakeContextCurrentAvailable = false;
                    this.wglMakeContextCurrentInitialized = true;
                }
            }
        }
        return this.wglMakeContextCurrentAvailable;
    }

    private final boolean wglMakeContextCurrent(long l, long l2, long l3) {
        boolean bl = false;
        if (this.wglMakeContextCurrentAvailable) {
            bl = this.getWGLExt().wglMakeContextCurrent(l, l2, l3);
        } else if (l == l2) {
            bl = WGL.wglMakeCurrent(l, l3);
        } else {
            throw new InternalError("Given readDrawable but no driver support");
        }
        if (!bl && 0L == l && 0L == l2) {
            return GDI.GetLastError() == 0;
        }
        return bl;
    }

    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getWGLExtProcAddressTable();
    }

    public final WGLExtProcAddressTable getWGLExtProcAddressTable() {
        return this.wglExtProcAddressTable;
    }

    protected Map getFunctionNameMap() {
        return functionNameMap;
    }

    protected Map getExtensionNameMap() {
        return extensionNameMap;
    }

    protected void destroyContextARBImpl(long l) {
        WGL.wglMakeCurrent(0L, 0L);
        WGL.wglDeleteContext(l);
    }

    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        long l2;
        block14: {
            WGLExt wGLExt = this.getWGLExt();
            this.updateGLXProcAddressTable();
            if (DEBUG) {
                System.err.println("WindowWGLContext.createContextARBImpl: " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation") + ", handle " + WindowsWGLContext.toHexString(this.drawable.getHandle()) + ", share " + WindowsWGLContext.toHexString(l) + ", direct " + bl + ", wglCreateContextAttribsARB: " + WindowsWGLContext.toHexString(this.wglExtProcAddressTable._addressof_wglCreateContextAttribsARB));
                Thread.dumpStack();
            }
            boolean bl2 = 0 != (2 & n);
            boolean bl3 = 0 != (0x10 & n);
            boolean bl4 = 0 != (0x40 & n);
            l2 = 0L;
            int[] nArray = new int[]{8337, n2, 8338, n3, 8340, 0, 0, 0, 0};
            if (n2 > 3 || n2 == 3 && n3 >= 2) {
                nArray[6] = 37158;
                nArray[7] = bl2 ? 2 : 1;
            }
            if (n2 >= 3) {
                if (!bl2 && bl3) {
                    nArray[5] = nArray[5] | 2;
                }
                if (bl4) {
                    nArray[5] = nArray[5] | 1;
                }
            }
            try {
                l2 = wGLExt.wglCreateContextAttribsARB(this.drawable.getHandle(), l, nArray, 0);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block14;
                Throwable throwable = new Throwable("Info: WindowWGLContext.createContextARBImpl wglCreateContextAttribsARB failed with " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"), runtimeException);
                throwable.printStackTrace();
            }
        }
        if (0L != l2) {
            if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), l2)) {
                if (DEBUG) {
                    System.err.println("WindowsWGLContext.createContextARB couldn't make current " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"));
                }
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createContextARBImpl: OK " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl);
            }
        } else if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": createContextARBImpl: NO " + WindowsWGLContext.getGLVersion(n2, n3, n, "@creation"));
        }
        return l2;
    }

    protected boolean createImpl() {
        WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)this.drawable.getFactoryImpl();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        WindowsWGLContext windowsWGLContext = (WindowsWGLContext)windowsWGLDrawableFactory.getOrCreateSharedContextImpl(abstractGraphicsDevice);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = this.drawable.getChosenGLCapabilities();
        this.isGLReadDrawableAvailable();
        WindowsWGLContext windowsWGLContext2 = (WindowsWGLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (windowsWGLContext2 != null && (l = windowsWGLContext2.getHandle()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        boolean bl = false;
        if (null != windowsWGLContext && windowsWGLContext.isCreatedWithARBMethod()) {
            this.contextHandle = this.createContextARB(l, true, nArray2, nArray, nArray3);
            bl = true;
            if (DEBUG && 0L != this.contextHandle) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: OK (ARB, using sharedContext) share " + l);
            }
        }
        long l2 = 0L;
        if (0L == this.contextHandle) {
            l2 = WGL.wglCreateContext(this.drawable.getHandle());
            if (l2 == 0L) {
                throw new GLException("Unable to create temp OpenGL context for device context " + WindowsWGLContext.toHexString(this.drawable.getHandle()));
            }
            if (!WGL.wglMakeCurrent(this.drawable.getHandle(), l2)) {
                throw new GLException("Error making temp context current: 0x" + WindowsWGLContext.toHexString(l2) + ", werr: " + GDI.GetLastError());
            }
            this.setGLFunctionAvailability(true, 0, 0, 34);
            boolean bl2 = this.isFunctionAvailable("wglCreateContextAttribsARB");
            WGL.wglMakeCurrent(0L, 0L);
            if (!bl) {
                if (bl2 && this.isExtensionAvailable("WGL_ARB_create_context")) {
                    this.contextHandle = this.createContextARB(l, true, nArray2, nArray, nArray3);
                    bl = true;
                    if (DEBUG) {
                        if (0L != this.contextHandle) {
                            System.err.println(WindowsWGLContext.getThreadName() + ": createContextImpl: OK (ARB, initial) share " + l);
                        } else {
                            System.err.println(WindowsWGLContext.getThreadName() + ": createContextImpl: NOT OK (ARB, initial) - creation failed - share " + l);
                        }
                    }
                } else if (DEBUG) {
                    System.err.println(WindowsWGLContext.getThreadName() + ": createContextImpl: NOT OK (ARB, initial) - extension not available - share " + l);
                }
            }
        }
        if (0L != this.contextHandle) {
            l = 0L;
            if (0L != l2) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException("Cannot make previous verified context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError());
                }
            }
        } else {
            if (gLCapabilitiesImmutable.getGLProfile().isGL3()) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                throw new GLException("WindowsWGLContext.createContext failed, but context > GL2 requested " + WindowsWGLContext.getGLVersion(nArray2[0], nArray[0], nArray3[0], "@creation") + ", ");
            }
            if (DEBUG) {
                System.err.println("WindowsWGLContext.createContext failed, fall back to !ARB context " + WindowsWGLContext.getGLVersion(nArray2[0], nArray[0], nArray3[0], "@creation"));
            }
            this.contextHandle = l2;
            if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(this.contextHandle);
                throw new GLException("Error making old context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError());
            }
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": createImpl: OK (old) share " + l);
            }
        }
        if (0L != l && !WGL.wglShareLists(l, this.contextHandle)) {
            throw new GLException("wglShareLists(" + WindowsWGLContext.toHexString(l) + ", " + WindowsWGLContext.toHexString(this.contextHandle) + ") failed: werr " + GDI.GetLastError());
        }
        return true;
    }

    protected void makeCurrentImpl(boolean bl) throws GLException {
        if (WGL.wglGetCurrentContext() != this.contextHandle) {
            if (!this.wglMakeContextCurrent(this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                throw new GLException("Error making context current: 0x" + WindowsWGLContext.toHexString(this.contextHandle) + ", werr: " + GDI.GetLastError() + ", " + this);
            }
            if (DEBUG && bl) {
                System.err.println(WindowsWGLContext.getThreadName() + ": wglMakeCurrent(hdc " + WindowsWGLContext.toHexString(this.drawable.getHandle()) + ", contextHandle " + WindowsWGLContext.toHexString(this.contextHandle) + ") succeeded");
            }
        }
    }

    protected void releaseImpl() throws GLException {
        if (!this.wglMakeContextCurrent(0L, 0L, 0L)) {
            throw new GLException("Error freeing OpenGL context, werr: " + GDI.GetLastError());
        }
    }

    protected void destroyImpl() throws GLException {
        WGL.wglMakeCurrent(0L, 0L);
        if (!WGL.wglDeleteContext(this.contextHandle)) {
            throw new GLException("Unable to delete OpenGL context");
        }
    }

    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        if (!WGL.wglCopyContext(gLContext.getHandle(), this.getHandle(), n)) {
            throw new GLException("wglCopyContext failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": !!! Initializing WGL extension address table: " + string);
        }
        this.wglGetExtensionsStringEXTInitialized = false;
        this.wglGetExtensionsStringEXTAvailable = false;
        this.wglMakeContextCurrentInitialized = false;
        this.wglMakeContextCurrentAvailable = false;
        WGLExtProcAddressTable wGLExtProcAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            wGLExtProcAddressTable = (WGLExtProcAddressTable)((Object)mappedGLXProcAddress.get(string));
        }
        if (null != wGLExtProcAddressTable) {
            this.wglExtProcAddressTable = wGLExtProcAddressTable;
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": !!! GLContext WGL ProcAddressTable reusing key(" + string + ") -> " + ((Object)((Object)wGLExtProcAddressTable)).hashCode());
            }
        } else {
            if (this.wglExtProcAddressTable == null) {
                this.wglExtProcAddressTable = new WGLExtProcAddressTable(new GLProcAddressResolver());
            }
            this.resetProcAddressTable(this.getWGLExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getWGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(WindowsWGLContext.getThreadName() + ": !!! GLContext WGL ProcAddressTable mapping key(" + string + ") -> " + ((Object)((Object)this.getWGLExtProcAddressTable())).hashCode());
                }
            }
        }
    }

    public String getPlatformExtensionsString() {
        if (!this.wglGetExtensionsStringEXTInitialized) {
            this.wglGetExtensionsStringEXTAvailable = WGL.wglGetProcAddress("wglGetExtensionsStringEXT") != 0L;
            this.wglGetExtensionsStringEXTInitialized = true;
        }
        if (this.wglGetExtensionsStringEXTAvailable) {
            return this.getWGLExt().wglGetExtensionsStringEXT();
        }
        return "";
    }

    protected void setSwapIntervalImpl(int n) {
        WGLExt wGLExt = this.getWGLExt();
        if (wGLExt.isExtensionAvailable("WGL_EXT_swap_control") && wGLExt.wglSwapIntervalEXT(n)) {
            this.currentSwapInterval = n;
        }
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        return this.getWGLExt().wglAllocateMemoryNV(n, f, f2, f3);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    static {
        functionNameMap.put("glAllocateMemoryNV", "wglAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "wglFreeMemoryNV");
        extensionNameMap = new HashMap();
        extensionNameMap.put("GL_ARB_pbuffer", "WGL_ARB_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "WGL_ARB_pixel_format");
    }
}

