/*
 * Decompiled with CFR 0.152.
 */
package com.iabcinc.common;

import java.awt.Color;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Config {
    private Properties props;
    private String configName;
    public static final String DEFAULT = "default";
    public static final String DEFAULTPFX = "default.";

    public Config(String resource) throws IOException {
        this.setConfigName(DEFAULT);
        this.props = new Properties();
        this.props.load(Config.class.getResourceAsStream(resource));
    }

    public String getProperty(String property) throws ConfigError {
        String prop = null;
        if (prop == null) {
            prop = this.props.getProperty(property);
        }
        if (prop == null) {
            prop = this.props.getProperty(this.configName + "." + property);
        }
        if (prop == null) {
            prop = this.props.getProperty(DEFAULTPFX + property);
        }
        if (prop == null) {
            throw new ConfigError("Could not find " + this.configName + "." + property);
        }
        Pattern pat = Pattern.compile("\\$\\{([a-zA-Z0-9_\\.]+)\\}");
        Matcher mat = pat.matcher(prop);
        while (mat.find()) {
            String varValue = this.getProperty(mat.group(1));
            prop = prop.replaceAll("\\$\\{" + mat.group(1).replaceAll("\\.", "\\\\\\.") + "\\}", varValue == null ? "" : varValue);
        }
        return prop;
    }

    public double getPropertyDouble(String property) throws ConfigError {
        double propd;
        String prop = this.getProperty(property);
        try {
            propd = Double.parseDouble(prop);
        }
        catch (NumberFormatException x) {
            throw new ConfigError("Not a double format: " + this.configName + "." + property, x);
        }
        return propd;
    }

    public int getPropertyInt(String property) throws ConfigError {
        int propi;
        String prop = this.getProperty(property);
        try {
            propi = Integer.parseInt(prop);
        }
        catch (NumberFormatException x) {
            throw new ConfigError("Not an int format: " + this.configName + "." + property, x);
        }
        return propi;
    }

    public String[] getStrings(String name) throws ConfigError {
        String stringlist = this.getProperty(name);
        String[] strings = stringlist.split(",");
        return strings;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public Color getColor(String property) throws ConfigError {
        String colorName = this.getProperty(property);
        if (colorName == null) {
            return Color.black;
        }
        if (colorName.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (colorName.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (colorName.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (colorName.equalsIgnoreCase("darkgray")) {
            return Color.darkGray;
        }
        if (colorName.equalsIgnoreCase("darkgrey")) {
            return Color.darkGray;
        }
        if (colorName.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (colorName.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (colorName.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (colorName.equalsIgnoreCase("lightgray")) {
            return Color.lightGray;
        }
        if (colorName.equalsIgnoreCase("lightgrey")) {
            return Color.lightGray;
        }
        if (colorName.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (colorName.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (colorName.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (colorName.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (colorName.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            return Color.decode(colorName);
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    public static class ConfigError
    extends Exception {
        private static final long serialVersionUID = 400084591928063862L;

        public ConfigError() {
        }

        public ConfigError(String message) {
            super(message);
        }

        public ConfigError(String message, Throwable cause) {
            super(message, cause);
        }

        public ConfigError(Throwable cause) {
            super(cause);
        }
    }
}

