/*
 * Decompiled with CFR 0.152.
 */
package com.iabcinc.mapping.voronoi.test;

import com.iabcinc.mapping.voronoi.Point;
import com.iabcinc.mapping.voronoi.Triangulation;
import com.iabcinc.mapping.voronoi.test.VoronoiVisualiser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SimpleTestCase {
    Vector<Point> points = new Vector();
    Triangulation tri = new Triangulation();

    void addPoint(double longitude, double latitude) {
        Point point = new Point(longitude, latitude);
        this.tri.insertSite(point);
        this.points.add(point);
    }

    void addPoints() {
        this.addPoint(-10.0, 10.0);
        this.addPoint(-10.0, -10.0);
        this.addPoint(10.0, -10.0);
        this.addPoint(10.0, 10.0);
        this.addPoint(8.0, 10.0);
        this.addPoint(5.0, 4.0);
        this.addPoint(5.0, 4.0);
        this.addPoint(-2.0, 5.0);
        this.addPoint(7.0, -3.0);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SimpleTestCase c = new SimpleTestCase();
        VoronoiVisualiser frame = new VoronoiVisualiser();
        c.readFile(SimpleTestCase.class.getResourceAsStream("/points.csv"));
        frame.setViewPort(122.009224, -47.608307, 1000.0, -1000.0);
        frame.setTriangulation(c.tri);
        frame.setPoints(c.points);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimpleTestCase.createAndShowGUI();
            }
        });
    }

    public void readFile(InputStream in) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            double longitude = 0.0;
            double latitude = 0.0;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                String[] elems;
                if ((line = line.trim()).equals("") || (elems = line.split(",")).length != 2) continue;
                try {
                    longitude = Double.parseDouble(elems[0]);
                    latitude = Double.parseDouble(elems[1]);
                }
                catch (NumberFormatException x) {
                    continue;
                }
                if (first) {
                    first = false;
                }
                this.addPoint(longitude, latitude);
            }
            reader.close();
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }
}

