/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import java.io.File;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.NewFileItemsOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.ProjectView;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Util;

public class NewFileItemsAction extends Action {

	private final IWorkbenchWindow window;

	public NewFileItemsAction(IWorkbenchWindow window) {
		super("ファイル...");
		this.window = window;

		setId(CommandIds.NEW_FILE_ITEMS);
		setActionDefinitionId(CommandIds.NEW_FILE_ITEMS);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/new_file_items.png"));
	}

	public void run() {
		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		if (pm == null) {
			return;
		}

		List<File> files = showFileDialog();
		if (files == null) {
			return;
		}

		ProjectView projectView = UIUtil.showView(window.getActivePage(), ProjectView.ID);

		Folder parent = projectView.getItemTreeInsertionPoint();
		pm.postOperation(new NewFileItemsOperation(pm, parent, files));
	}

	private List<File> showFileDialog() {
		String[] filterNames = new String[] { "All Files (*)" };
		String[] filterExtensions = new String[] { "*" };

		String platform = SWT.getPlatform();
		if (platform.equals("win32") || platform.equals("wpf")) {
			filterNames = new String[] { "All Files (*.*)" };
			filterExtensions = new String[] { "*.*" };
		}

		FileDialog dialog = new FileDialog(window.getShell(), SWT.OPEN | SWT.MULTI | SWT.SHEET);
		dialog.setFilterNames(filterNames);
		dialog.setFilterExtensions(filterExtensions);

		if (dialog.open() == null) {
			return null;
		}

		List<File> files = Util.newList();
		String parent = dialog.getFilterPath();
		for (String filename : dialog.getFileNames()) {
			files.add(new File(parent, filename));
		}
		return files;
	}

}
