/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.WString;

public class Windows {

	public static final boolean WINDOWS;

	public static final Kernel32 KERNEL32;

	static {
		WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");

		Kernel32 k = null;
		if (WINDOWS) {
			k = (Kernel32) Native.loadLibrary("Kernel32", Kernel32.class);
		}
		KERNEL32 = k;
	}

	public interface Kernel32 extends Library {

		public static final int FILE_ATTRIBUTE_ARCHIVE				= 0x00000020;
		public static final int FILE_ATTRIBUTE_HIDDEN				= 0x00000002;
		public static final int FILE_ATTRIBUTE_NORMAL				= 0x00000080;
		public static final int FILE_ATTRIBUTE_NOT_CONTENT_INDEXED	= 0x00002000;
		public static final int FILE_ATTRIBUTE_OFFLINE				= 0x00001000;
		public static final int FILE_ATTRIBUTE_READONLY				= 0x00000001;
		public static final int FILE_ATTRIBUTE_SYSTEM				= 0x00000004;
		public static final int FILE_ATTRIBUTE_TEMPORARY			= 0x00000100;

		boolean SetFileAttributesW(WString fileName, int fileAttributes);

	}

}
