/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.audio.windows.waveout;

import com.jogamp.audio.windows.waveout.Track;
import com.jogamp.audio.windows.waveout.Vec3f;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Mixer {
    private static Mixer mixer = new Mixer();
    private volatile boolean shutdown;
    private volatile Object shutdownLock = new Object();
    private volatile boolean shutdownDone;
    private long event;
    private volatile ArrayList tracks = new ArrayList();
    private Vec3f leftSpeakerPosition = new Vec3f(-1.0f, 0.0f, 0.0f);
    private Vec3f rightSpeakerPosition = new Vec3f(1.0f, 0.0f, 0.0f);
    private float falloffFactor = 1.0f;
    private static Class directByteBufferClass;
    private static Constructor directByteBufferConstructor;
    private static Map createdBuffers;

    private Mixer() {
        this.event = Mixer.CreateEvent();
        new FillerThread().start();
        MixerThread mixerThread = new MixerThread();
        mixerThread.setPriority(9);
        mixerThread.start();
    }

    public static Mixer getMixer() {
        return mixer;
    }

    synchronized void add(Track track) {
        ArrayList arrayList = (ArrayList)this.tracks.clone();
        arrayList.add(track);
        this.tracks = arrayList;
    }

    synchronized void remove(Track track) {
        ArrayList arrayList = (ArrayList)this.tracks.clone();
        arrayList.remove(track);
        this.tracks = arrayList;
    }

    public void setLeftSpeakerPosition(float f, float f2, float f3) {
        this.leftSpeakerPosition.set(f, f2, f3);
    }

    public void setRightSpeakerPosition(float f, float f2, float f3) {
        this.rightSpeakerPosition.set(f, f2, f3);
    }

    public void setFalloffFactor(float f) {
        this.falloffFactor = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            Mixer.SetEvent(this.event);
            try {
                this.shutdownLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static native boolean initializeWaveOut(long var0);

    private static native void shutdownWaveOut();

    private static native long getNextMixerBuffer();

    private static native ByteBuffer getMixerBufferData(long var0);

    private static native long getMixerBufferDataAddress(long var0);

    private static native int getMixerBufferDataCapacity(long var0);

    private static native boolean prepareMixerBuffer(long var0);

    private static native boolean writeMixerBuffer(long var0);

    private static native long CreateEvent();

    private static native boolean WaitForSingleObject(long var0);

    private static native void SetEvent(long var0);

    private static native void CloseHandle(long var0);

    private static ByteBuffer newDirectByteBuffer(long l, long l2) {
        Long l3 = new Long(l);
        ByteBuffer byteBuffer = (ByteBuffer)createdBuffers.get(l3);
        if (byteBuffer == null && (byteBuffer = Mixer.newDirectByteBufferImpl(l, l2)) != null) {
            createdBuffers.put(l3, byteBuffer);
        }
        return byteBuffer;
    }

    private static ByteBuffer newDirectByteBufferImpl(long l, long l2) {
        if (directByteBufferClass == null) {
            try {
                directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
                byte[] byArray = new byte[]{};
                directByteBufferConstructor = directByteBufferClass.getDeclaredConstructor(Integer.TYPE, byArray.getClass(), Integer.TYPE);
                directByteBufferConstructor.setAccessible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (directByteBufferConstructor != null) {
            try {
                return (ByteBuffer)directByteBufferConstructor.newInstance(new Integer((int)l2), null, new Integer((int)l));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    static {
        createdBuffers = new HashMap();
    }

    class MixerThread
    extends Thread {
        float[] mixingBuffer;
        private Vec3f temp;

        MixerThread() {
            super("Mixer Thread");
            this.temp = new Vec3f();
            if (!Mixer.initializeWaveOut(Mixer.this.event)) {
                throw new InternalError("Error initializing waveout device");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Mixer.this.shutdown) {
                long l = Mixer.getNextMixerBuffer();
                if (l != 0L) {
                    ByteBuffer byteBuffer = Mixer.getMixerBufferData(l);
                    if (byteBuffer == null) {
                        byteBuffer = Mixer.newDirectByteBuffer(Mixer.getMixerBufferDataAddress(l), Mixer.getMixerBufferDataCapacity(l));
                    }
                    if (byteBuffer == null) {
                        throw new InternalError("Couldn't wrap the native address with a direct byte buffer");
                    }
                    if (this.mixingBuffer == null || this.mixingBuffer.length < byteBuffer.capacity() / 2) {
                        this.mixingBuffer = new float[byteBuffer.capacity() / 2];
                    } else {
                        for (int i = 0; i < this.mixingBuffer.length; ++i) {
                            this.mixingBuffer[i] = 0.0f;
                        }
                    }
                    if (this.mixingBuffer.length % 2 != 0) {
                        String string = "FATAL ERROR: odd number of samples in the mixing buffer";
                        System.out.println(string);
                        throw new InternalError(string);
                    }
                    ArrayList arrayList = Mixer.this.tracks;
                    Iterator iterator = arrayList.iterator();
                    block5: while (iterator.hasNext()) {
                        Track track = (Track)iterator.next();
                        if (!track.isPlaying()) continue;
                        Vec3f vec3f = track.getPosition();
                        float f = this.gain(vec3f, Mixer.this.leftSpeakerPosition);
                        float f2 = this.gain(vec3f, Mixer.this.rightSpeakerPosition);
                        int n = 0;
                        while (n < this.mixingBuffer.length) {
                            if (track.hasNextSample()) {
                                float f3 = track.nextSample();
                                this.mixingBuffer[n++] = f3 * f;
                                this.mixingBuffer[n++] = f3 * f2;
                                continue;
                            }
                            if (!track.done()) continue block5;
                            Mixer.this.remove(track);
                            continue block5;
                        }
                    }
                    int n = 0;
                    for (int i = 0; i < this.mixingBuffer.length; ++i) {
                        short s = (short)this.mixingBuffer[i];
                        byteBuffer.put(n++, (byte)s);
                        byteBuffer.put(n++, (byte)(s >> 8));
                    }
                    if (!Mixer.prepareMixerBuffer(l)) {
                        throw new RuntimeException("Error preparing mixer buffer");
                    }
                    if (Mixer.writeMixerBuffer(l)) continue;
                    throw new RuntimeException("Error writing mixer buffer to device");
                }
                if (Mixer.WaitForSingleObject(Mixer.this.event)) continue;
                throw new RuntimeException("Error while waiting for event object");
            }
            Mixer.shutdownWaveOut();
            Object object = Mixer.this.shutdownLock;
            synchronized (object) {
                Mixer.this.shutdownLock.notifyAll();
            }
        }

        private float gain(Vec3f vec3f, Vec3f vec3f2) {
            this.temp.sub(vec3f, vec3f2);
            float f = this.temp.dot(this.temp);
            return Mixer.this.falloffFactor / (Mixer.this.falloffFactor + f);
        }
    }

    class FillerThread
    extends Thread {
        FillerThread() {
            super("Mixer Thread");
        }

        public void run() {
            while (!Mixer.this.shutdown) {
                ArrayList arrayList = Mixer.this.tracks;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Track track = (Track)iterator.next();
                    try {
                        track.fill();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Mixer.this.remove(track);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

