/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl.jawt.windows;

import com.jogamp.nativewindow.impl.jawt.JAWT;
import com.jogamp.nativewindow.impl.jawt.JAWTWindow;
import com.jogamp.nativewindow.impl.jawt.JAWT_DrawingSurface;
import com.jogamp.nativewindow.impl.jawt.JAWT_DrawingSurfaceInfo;
import com.jogamp.nativewindow.impl.jawt.windows.JAWT_Win32DrawingSurfaceInfo;
import com.jogamp.nativewindow.impl.windows.GDI;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Point;

public class WindowsJAWTWindow
extends JAWTWindow {
    private JAWT_DrawingSurface ds;
    private boolean dsLocked;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_Win32DrawingSurfaceInfo win32dsi;
    protected long windowHandle;

    public WindowsJAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(object, abstractGraphicsConfiguration);
    }

    protected void validateNative() throws NativeWindowException {
    }

    protected synchronized void invalidate() {
        super.invalidate();
        this.windowHandle = 0L;
    }

    protected int lockSurfaceImpl() throws NativeWindowException {
        int n = 3;
        this.ds = JAWT.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        int n2 = this.ds.Lock();
        boolean bl = this.dsLocked = 0 == (n2 & 1);
        if (!this.dsLocked) {
            this.unlockSurfaceImpl();
            throw new NativeWindowException("Unable to lock surface");
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.win32dsi = (JAWT_Win32DrawingSurfaceInfo)this.dsi.platformInfo();
        if (this.win32dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.windowHandle = this.win32dsi.getHandle();
        this.drawable = this.win32dsi.getHdc();
        if (this.windowHandle == 0L || this.drawable == 0L) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.updateBounds(this.dsi.getBounds());
        return n;
    }

    protected void unlockSurfaceImpl() throws NativeWindowException {
        long l = 0L;
        if (null != this.ds) {
            if (null != this.dsi) {
                this.ds.FreeDrawingSurfaceInfo(this.dsi);
            }
            if (this.dsLocked) {
                this.ds.Unlock();
            }
            JAWT.getJAWT().FreeDrawingSurface(this.ds);
        }
        this.ds = null;
        this.dsi = null;
        this.win32dsi = null;
    }

    public long getWindowHandle() {
        return this.windowHandle;
    }

    protected Point getLocationOnScreenImpl(int n, int n2) {
        return GDI.GetRelativeLocation(this.getWindowHandle(), 0L, n, n2);
    }
}

