/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Widget;

import ch.kuramo.javie.core.JavieRuntimeException;

public class ColorDialogBugFix {

	public static void patch() {
		String platform = SWT.getPlatform();

		if (platform.equals("cocoa")) {
			cocoa();
		}
	}

	private static void cocoa() {
		try {
			ClassLoader loader = Widget.class.getClassLoader();

			ClassPool pool = new ClassPool();
			pool.appendClassPath(new LoaderClassPath(loader));
			CtClass targetClass = pool.get("org.eclipse.swt.widgets.ColorDialog");

			CtMethod method = targetClass.getDeclaredMethod("open", new CtClass[0]);
			method.instrument(new ExprEditor() {
				public void edit(MethodCall m) throws CannotCompileException {
					if (m.getClassName().equals("org.eclipse.swt.internal.cocoa.NSApplication")
							&& m.getMethodName().equals("runModalForWindow")) {
						String src = "$_ = $proceed($$); selected = true;";
						m.replace(src);
					}
				}

				public void edit(NewExpr e) throws CannotCompileException {
					if (e.getClassName().equals("org.eclipse.swt.graphics.RGB")) {
						String src = "$_ = new org.eclipse.swt.graphics.RGB("
											+ "(int)Math.round(color.redComponent() * 255),"
											+ "(int)Math.round(color.greenComponent() * 255),"
											+ "(int)Math.round(color.blueComponent() * 255));";
						e.replace(src);
					}
				}
			});

			targetClass.toClass(loader, null);

		} catch (NotFoundException e) {
			throw new JavieRuntimeException(e);
		} catch (CannotCompileException e) {
			throw new JavieRuntimeException(e);
		}
	}

}
