/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import java.util.Set;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchWindow;

import ch.kuramo.javie.app.project.AddExpressionsOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;

public class AddExpressionsAction extends Action implements ISelectionChangedListener {

	private final IWorkbenchWindow window;

	private final Set<AnimatableValueElement> elements = Util.newLinkedHashSet();


	public AddExpressionsAction(IWorkbenchWindow window, Viewer viewer) {
		super("エクスプレッションの追加");
		this.window = window;

		//setId(CommandIds.ADD_EXPRESSIONS);
		//setActionDefinitionId(CommandIds.ADD_EXPRESSIONS);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/add_expressions.png"));

		updateState(viewer.getSelection());
		viewer.addSelectionChangedListener(this);
	}

	private void updateState(ISelection selection) {
		elements.clear();

		if (selection instanceof IStructuredSelection) {
			for (Object o : ((IStructuredSelection) selection).toList()) {
				if (o instanceof AnimatableValueElement) {
					AnimatableValueElement element = (AnimatableValueElement) o;
					if (!element.hasExpression()) {
						elements.add(element);
						continue;
					}
				}
				elements.clear();
				break;
			}
		}

		setEnabled(!elements.isEmpty());
	}

	public void selectionChanged(SelectionChangedEvent event) {
		updateState(event.getSelection());
	}

	public void run() {
		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		LayerCompositionView view = (LayerCompositionView) window.getActivePage().getActivePart();
		LayerComposition comp = view.getLayerComposition();

		AddExpressionsOperation op = new AddExpressionsOperation(pm, comp);

		// オペレーションを実行すると選択状態が変化するので、コピーを作る
		Set<AnimatableValueElement> elements = Util.newLinkedHashSet(this.elements);

		for (AnimatableValueElement element : elements) {
			op.add(element.createAddExpressionOperation(pm));
		}

		pm.postOperation(op);

		if (elements.size() == 1) {
			view.editExpression((AnimatableValueElement) elements.iterator().next());
		}
	}

}
