/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie2mmd;

import org.eclipse.jface.wizard.Wizard;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.actions.AbstractOutputAction;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.output.Javie2MMDOutput;

import com.google.inject.Injector;

public class Javie2MMDAction extends AbstractOutputAction<Javie2MMDOutput> {

	public Javie2MMDAction(LayerCompositionView view) {
		super("MMD カメラデータ (.vmdファイル) ...", view);
		setId(CommandIds.JAVIE2MMD);
		setActionDefinitionId(CommandIds.JAVIE2MMD);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/javie2mmd_output.png"));
	}

	@Override
	protected String getDefaultExtension() {
		return ".vmd";
	}

	@Override
	protected Javie2MMDOutput createOutput(Injector injector) {
		return injector.getInstance(Javie2MMDOutput.class);
	}

	@Override
	protected Wizard createWizard(Javie2MMDOutput output) {
		return new Javie2MMDWizard(getComposition().getSize(), output);
	}

	@Override
	protected String getSubTaskText(int currentWork, int totalWork) {
		return String.format("フレーム: %d/%d", currentWork, totalWork);
	}

}
