package ch.kuramo.javie.core.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;

import com.google.inject.Inject;
import com.google.inject.Injector;

public class AviSynthWrapSource extends AviSynthSource {

	@Inject
	public AviSynthWrapSource(
			RenderContext context, IVideoRenderSupport vrSupport,
			AudioRenderSupport arSupport, IArrayPools arrayPools,
			Injector injector) {

		super(context, vrSupport, arSupport, arrayPools, injector);
	}

	@Override
	public boolean initialize(File file) {
		if (hasExtension(file, "avi") && initialize(file, false)) {
			return true;
		} else {
			return initialize(file, true);
		}
	}

	private boolean initialize(File file, boolean ds) {
		File avsFile = null;
		try {
			avsFile = File.createTempFile("tmp", ".avs");

			PrintWriter pw = new PrintWriter(
					new OutputStreamWriter(new FileOutputStream(avsFile), "Windows-31J"));
			try {
				pw.printf("%s(\"%s\", pixel_type=\"RGB32\")%n",
						ds ? "DirectShowSource" : "AVISource", file.getAbsolutePath());
				pw.println("return last");
			} finally {
				pw.close();
			}

			return super.initialize(avsFile);

		} catch (IOException e) {
			throw new JavieRuntimeException(e);
		} finally {
			if (avsFile != null) avsFile.delete();
		}
	}

}
