/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.services.IAntiAliasSupport;

import com.google.inject.Inject;
import com.google.inject.Injector;

public class AntiAliasSupportProxy implements IAntiAliasSupport {

	private static final ThreadLocal<AntiAliasSupportImpl>
			_threadLocal = new ThreadLocal<AntiAliasSupportImpl>();


	static class Lifecycle {

		private final Injector _injector;

		@Inject
		Lifecycle(Injector injector) {
			_injector = injector;
		}

		void createImpl() {
			if (_threadLocal.get() != null) {
				throw new IllegalStateException("AntiAliasSupportImpl already exists on this thread.");
			}
			AntiAliasSupportImpl impl = _injector.getInstance(AntiAliasSupportImpl.class);
			_threadLocal.set(impl);
		}

		void disposeImpl() {
			AntiAliasSupportImpl impl = _threadLocal.get();
			if (impl != null) {
				impl.dispose();
				_threadLocal.set(null);
			}
		}
	}


	private AntiAliasSupportImpl getImpl() {
		AntiAliasSupportImpl impl = _threadLocal.get();
		if (impl == null) {
			throw new IllegalStateException("No AntiAliasSupportImpl exist on this thread.");
		}
		return impl;
	}

	public void antiAlias(int width, int height, boolean depthTest, Color clearColor, Runnable operation) {
		getImpl().antiAlias(width, height, depthTest, clearColor, operation);
	}

	public void antiAlias(int width, int height, Runnable operation) {
		getImpl().antiAlias(width, height, operation);
	}

}
